/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.springframework.integration.store.AbstractKeyValueMessageStore;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class GemfireMessageStore
extends AbstractKeyValueMessageStore {
    private final Region<Object, Object> messageStoreRegion;

    public GemfireMessageStore(Region<Object, Object> messageStoreRegion) {
        this(messageStoreRegion, "");
    }

    public GemfireMessageStore(Region<Object, Object> messageStoreRegion, String prefix) {
        super(prefix);
        Assert.notNull(messageStoreRegion, (String)"'messageStoreRegion' must not be null");
        this.messageStoreRegion = messageStoreRegion;
    }

    protected Object doRetrieve(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return this.messageStoreRegion.get(id);
    }

    protected void doStore(Object id, Object objectToStore) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)objectToStore, (String)"'objectToStore' must not be null");
        this.messageStoreRegion.put(id, objectToStore);
    }

    protected void doStoreIfAbsent(Object id, Object objectToStore) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)objectToStore, (String)"'objectToStore' must not be null");
        Object present = this.messageStoreRegion.putIfAbsent(id, objectToStore);
        if (present != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The message: [" + present + "] is already present in the store. The [" + objectToStore + "] is ignored."));
        }
    }

    protected Object doRemove(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return this.messageStoreRegion.remove(id);
    }

    protected void doRemoveAll(Collection<Object> ids) {
        this.messageStoreRegion.removeAll(ids);
    }

    protected Collection<?> doListKeys(String keyPattern) {
        Assert.hasText((String)keyPattern, (String)"'keyPattern' must not be empty");
        Set keys = this.messageStoreRegion.keySet();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Object key : keys) {
            String keyValue = key.toString();
            if (!PatternMatchUtils.simpleMatch((String)keyPattern, (String)keyValue)) continue;
            keyList.add(keyValue);
        }
        return keyList;
    }
}

