/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class FtpFileInfo
extends AbstractFileInfo<FTPFile> {
    private final FTPFile ftpFile;

    public FtpFileInfo(FTPFile ftpFile) {
        Assert.notNull((Object)ftpFile, (String)"FTPFile must not be null");
        this.ftpFile = ftpFile;
    }

    public boolean isDirectory() {
        return this.ftpFile.isDirectory();
    }

    public boolean isLink() {
        return this.ftpFile.isSymbolicLink();
    }

    public long getSize() {
        return this.ftpFile.getSize();
    }

    public long getModified() {
        return this.ftpFile.getTimestamp().getTimeInMillis();
    }

    public String getFilename() {
        return this.ftpFile.getName();
    }

    public String getPermissions() {
        StringBuilder sb = new StringBuilder();
        this.appendPermissionString(sb, this.ftpFile.isDirectory(), 'd', this.ftpFile.isSymbolicLink(), 'l');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(0, 0), 'r');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(0, 1), 'w');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(0, 2), 'x');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(1, 0), 'r');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(1, 1), 'w');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(1, 2), 'x');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(2, 0), 'r');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(2, 1), 'w');
        this.appendPermissionString(sb, this.ftpFile.hasPermission(2, 2), 'x');
        return sb.toString();
    }

    private void appendPermissionString(StringBuilder sb, boolean condition1, char char1, boolean condition2, char char2) {
        if (condition1) {
            sb.append(char1);
        } else if (condition2) {
            sb.append(char2);
        } else {
            sb.append('-');
        }
    }

    private void appendPermissionString(StringBuilder sb, boolean condition, char char1) {
        if (condition) {
            sb.append(char1);
        } else {
            sb.append('-');
        }
    }

    public FTPFile getFileInfo() {
        return this.ftpFile;
    }
}

