/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.server;

import java.io.IOException;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.ftp.server.DirectoryCreatedEvent;
import org.springframework.integration.ftp.server.FileWrittenEvent;
import org.springframework.integration.ftp.server.PathMovedEvent;
import org.springframework.integration.ftp.server.PathRemovedEvent;
import org.springframework.integration.ftp.server.SessionClosedEvent;
import org.springframework.integration.ftp.server.SessionOpenedEvent;
import org.springframework.util.Assert;

public class ApacheMinaFtplet
extends DefaultFtplet
implements ApplicationEventPublisherAware,
BeanNameAware,
InitializingBean {
    private ApplicationEventPublisher applicationEventPublisher;
    private String beanName;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void afterPropertiesSet() {
        Assert.state((this.applicationEventPublisher != null ? 1 : 0) != 0, (String)"An ApplicationEventPublisher is required");
    }

    public FtpletResult onConnect(FtpSession session) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SessionOpenedEvent(session));
        return super.onConnect(session);
    }

    public FtpletResult onDisconnect(FtpSession session) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SessionClosedEvent(session));
        return super.onDisconnect(session);
    }

    public FtpletResult onDeleteEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PathRemovedEvent(session, request, false));
        return super.onDeleteEnd(session, request);
    }

    public FtpletResult onUploadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new FileWrittenEvent(session, request, false));
        return super.onUploadEnd(session, request);
    }

    public FtpletResult onRmdirEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PathRemovedEvent(session, request, true));
        return super.onRmdirEnd(session, request);
    }

    public FtpletResult onMkdirEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DirectoryCreatedEvent(session, request));
        return super.onMkdirEnd(session, request);
    }

    public FtpletResult onAppendEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new FileWrittenEvent(session, request, false));
        return super.onAppendEnd(session, request);
    }

    public FtpletResult onRenameEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PathMovedEvent(session, request));
        return super.onRenameEnd(session, request);
    }

    public String toString() {
        return "ApacheMinaSftpEventListener [beanName=" + this.beanName + "]";
    }
}

