/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class FtpFileInfo
extends AbstractFileInfo<FTPFile> {
    private final FTPFile ftpFile;

    public FtpFileInfo(FTPFile ftpFile) {
        Assert.notNull((Object)ftpFile, (String)"FTPFile must not be null");
        this.ftpFile = ftpFile;
    }

    public boolean isDirectory() {
        return this.ftpFile.isDirectory();
    }

    public boolean isLink() {
        return this.ftpFile.isSymbolicLink();
    }

    public long getSize() {
        return this.ftpFile.getSize();
    }

    public long getModified() {
        return this.ftpFile.getTimestamp().getTimeInMillis();
    }

    public String getFilename() {
        return this.ftpFile.getName();
    }

    public String getPermissions() {
        StringBuilder sb = new StringBuilder();
        if (this.ftpFile.isDirectory()) {
            sb.append("d");
        } else if (this.ftpFile.isSymbolicLink()) {
            sb.append("l");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(0, 0)) {
            sb.append("r");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(0, 1)) {
            sb.append("w");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(0, 2)) {
            sb.append("x");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(1, 0)) {
            sb.append("r");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(1, 1)) {
            sb.append("w");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(1, 2)) {
            sb.append("x");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(2, 0)) {
            sb.append("r");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(2, 1)) {
            sb.append("w");
        } else {
            sb.append("-");
        }
        if (this.ftpFile.hasPermission(2, 2)) {
            sb.append("x");
        } else {
            sb.append("-");
        }
        return sb.toString();
    }

    public FTPFile getFileInfo() {
        return this.ftpFile;
    }
}

