/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.transformer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractFilePayloadTransformer<T>
implements Transformer,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean deleteFiles;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private boolean messageBuilderFactorySet;
    private volatile BeanFactory beanFactory;

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public final Message<?> transform(Message<?> message) {
        try {
            Assert.notNull(message, (String)"Message must not be null");
            Object payload = message.getPayload();
            Assert.notNull((Object)payload, (String)"Message payload must not be null");
            Assert.isInstanceOf(File.class, (Object)payload, (String)"Message payload must be of type [java.io.File]");
            File file = (File)payload;
            T result = this.transformFile(file);
            Message transformedMessage = this.getMessageBuilderFactory().withPayload(result).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("file_originalFile", (Object)file).setHeaderIfAbsent("file_name", (Object)file.getName()).build();
            if (this.deleteFiles && !file.delete() && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("failed to delete File '" + String.valueOf(file) + "'"));
            }
            return transformedMessage;
        }
        catch (Exception ex) {
            throw new MessagingException(message, "failed to transform File Message", (Throwable)ex);
        }
    }

    protected abstract T transformFile(File var1) throws IOException;
}

