/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.io.File;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.file.event.FileIntegrationEvent;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class FileTailingMessageProducerSupport
extends MessageProducerSupport
implements ApplicationEventPublisherAware {
    public static final long DEFAULT_TAIL_ATTEMPTS_DELAY = 5000L;
    private final AtomicLong lastNoMessageAlert = new AtomicLong();
    private @Nullable File file;
    private ApplicationEventPublisher eventPublisher;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private long tailAttemptsDelay = 5000L;
    private long idleEventInterval = 0L;
    private volatile long lastProduce = System.currentTimeMillis();
    private volatile @Nullable ScheduledFuture<?> idleEventScheduledFuture;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setFile(File file) {
        Assert.notNull((Object)file, (String)"'file' cannot be null");
        this.file = file;
    }

    protected File getFile() {
        Assert.state((this.file != null ? 1 : 0) != 0, (String)"'file' cannot be null");
        return this.file;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
    }

    public void setTailAttemptsDelay(long tailAttemptsDelay) {
        Assert.isTrue((tailAttemptsDelay > 0L ? 1 : 0) != 0, (String)"'tailAttemptsDelay' must be > 0");
        this.tailAttemptsDelay = tailAttemptsDelay;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        Assert.isTrue((idleEventInterval > 0L ? 1 : 0) != 0, (String)"'idleEventInterval' must be > 0");
        this.idleEventInterval = idleEventInterval;
    }

    protected long getMissingFileDelay() {
        return this.tailAttemptsDelay;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public String getComponentType() {
        return "file:tail-inbound-channel-adapter";
    }

    protected void send(String line) {
        File theFile = this.getFile();
        Message message = this.getMessageBuilderFactory().withPayload((Object)line).setHeader("file_name", (Object)theFile.getName()).setHeader("file_originalFile", (Object)theFile).build();
        super.sendMessage(message);
        this.updateLastProduce();
    }

    protected void publish(String message) {
        FileTailingEvent event = new FileTailingEvent((Object)this, message, this.getFile());
        this.eventPublisher.publishEvent((ApplicationEvent)event);
    }

    protected void doStart() {
        if (this.idleEventInterval > 0L) {
            this.idleEventScheduledFuture = this.getTaskScheduler().scheduleWithFixedDelay(() -> {
                long now = System.currentTimeMillis();
                long lastAlertAt = this.lastNoMessageAlert.get();
                long lastSend = this.lastProduce;
                if (now > lastSend + this.idleEventInterval && now > lastAlertAt + this.idleEventInterval && this.lastNoMessageAlert.compareAndSet(lastAlertAt, now)) {
                    this.publishIdleEvent(now - lastSend);
                }
            }, Duration.ofMillis(this.idleEventInterval));
        }
    }

    protected void doStop() {
        ScheduledFuture<?> idleEventScheduledFutureToCancel = this.idleEventScheduledFuture;
        if (idleEventScheduledFutureToCancel != null) {
            idleEventScheduledFutureToCancel.cancel(true);
        }
    }

    private void publishIdleEvent(long idleTime) {
        if (this.getFile().exists()) {
            FileTailingIdleEvent event = new FileTailingIdleEvent((Object)this, this.getFile(), idleTime);
            this.eventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    private void updateLastProduce() {
        if (this.idleEventInterval > 0L) {
            this.lastProduce = System.currentTimeMillis();
        }
    }

    public static class FileTailingEvent
    extends FileIntegrationEvent {
        private static final long serialVersionUID = -3382255736225946206L;
        private final String message;
        private final File file;

        public FileTailingEvent(Object source, String message, File file) {
            super(source);
            this.message = message;
            this.file = file;
        }

        public String getMessage() {
            return this.message;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return "FileTailingEvent " + super.toString() + " [message=" + this.message + ", file=" + this.file.getAbsolutePath() + "]";
        }
    }

    public static class FileTailingIdleEvent
    extends FileTailingEvent {
        private static final long serialVersionUID = -967118535347976767L;
        private final long idleTime;

        public FileTailingIdleEvent(Object source, File file, long idleTime) {
            super(source, "Idle timeout", file);
            this.idleTime = idleTime;
        }

        @Override
        public String toString() {
            return super.toString() + " [idle time=" + this.idleTime + "]";
        }
    }
}

