/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.gateway;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.integration.support.PartialSuccessException;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRemoteFileOutboundGateway<F>
extends AbstractReplyProducingMessageHandler {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private final Command command;
    private final Set<Option> options = new HashSet<Option>();
    private final ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private final MessageSessionCallback<F, ?> messageSessionCallback;
    private ExpressionEvaluatingMessageProcessor<String> renameProcessor = new ExpressionEvaluatingMessageProcessor((Expression)new FunctionExpression(m -> m.getHeaders().get((Object)"file_renameTo")));
    private Expression localDirectoryExpression;
    private boolean autoCreateLocalDirectory = true;
    private FileListFilter<F> filter;
    private boolean filterAfterEnhancement;
    private FileListFilter<File> mputFilter;
    private Expression localFilenameGeneratorExpression;
    private Expression fileExistsModeExpression;
    private FileExistsMode fileExistsMode;
    private EvaluationContext standardEvaluationContext;
    private Integer chmod;
    private boolean remoteFileTemplateExplicitlySet;

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, MessageSessionCallback<F, ?> messageSessionCallback) {
        this(new RemoteFileTemplate<F>(sessionFactory), messageSessionCallback);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, MessageSessionCallback<F, ?> messageSessionCallback) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        Assert.notNull(messageSessionCallback, (String)"'messageSessionCallback' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.messageSessionCallback = messageSessionCallback;
        this.fileNameProcessor = null;
        this.command = null;
        this.remoteFileTemplateExplicitlySet(true);
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, String command, @Nullable String expression) {
        this(sessionFactory, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, Command command, @Nullable String expression) {
        this(new RemoteFileTemplate<F>(sessionFactory), command, expression);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, String command, @Nullable String expression) {
        this(remoteFileTemplate, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, Command command, @Nullable String expressionArg) {
        boolean expressionNeeded;
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.command = command;
        String expression = expressionArg;
        boolean bl = expressionNeeded = !Command.LS.equals((Object)this.command) && !Command.NLST.equals((Object)this.command) && !Command.PUT.equals((Object)this.command) && !Command.MPUT.equals((Object)this.command);
        if (!StringUtils.hasText((String)expression) && expressionNeeded) {
            expression = "payload";
        }
        if (!StringUtils.hasText((String)expression)) {
            this.fileNameProcessor = null;
        } else {
            Expression parsedExpression = new SpelExpressionParser().parseExpression(expression);
            this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(parsedExpression);
            this.setPrimaryExpression(parsedExpression);
        }
        this.messageSessionCallback = null;
        this.remoteFileTemplateExplicitlySet(true);
    }

    protected final void remoteFileTemplateExplicitlySet(boolean remoteFileTemplateExplicitlySet) {
        this.remoteFileTemplateExplicitlySet = remoteFileTemplateExplicitlySet;
    }

    protected void assertRemoteFileTemplateMutability(String propertyName) {
        Assert.state((!this.remoteFileTemplateExplicitlySet ? 1 : 0) != 0, () -> "The '" + propertyName + "' must be set on the externally provided: " + String.valueOf(this.remoteFileTemplate));
    }

    public void setOptions(String options) {
        Assert.hasText((String)options, (String)"'options' must not be empty.");
        this.options.clear();
        Arrays.stream(options.split("\\s")).filter(StringUtils::hasText).map(s -> Option.toOption(s.trim())).forEach(this.options::add);
    }

    public void setOption(Option ... options) {
        Assert.notNull((Object)options, (String)"'options' must not be null");
        Assert.noNullElements((Object[])options, (String)"'options' cannot contain null element");
        this.options.clear();
        Collections.addAll(this.options, options);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.assertRemoteFileTemplateMutability("remoteFileSeparator");
        this.remoteFileTemplate.setRemoteFileSeparator(remoteFileSeparator);
    }

    public void setLocalDirectory(File localDirectory) {
        if (localDirectory != null) {
            this.localDirectoryExpression = new ValueExpression((Object)localDirectory);
        }
    }

    public void setLocalDirectoryExpression(Expression localDirectoryExpression) {
        this.localDirectoryExpression = localDirectoryExpression;
    }

    public void setLocalDirectoryExpressionString(String localDirectoryExpression) {
        this.localDirectoryExpression = EXPRESSION_PARSER.parseExpression(localDirectoryExpression);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.assertRemoteFileTemplateMutability("temporaryFileSuffix");
        this.remoteFileTemplate.setTemporaryFileSuffix(temporaryFileSuffix);
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.assertRemoteFileTemplateMutability("autoCreateDirectory");
        this.remoteFileTemplate.setAutoCreateDirectory(autoCreateDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.assertRemoteFileTemplateMutability("remoteDirectoryExpression");
        this.remoteFileTemplate.setRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        this.assertRemoteFileTemplateMutability("temporaryRemoteDirectoryExpression");
        this.remoteFileTemplate.setTemporaryRemoteDirectoryExpression(temporaryRemoteDirectoryExpression);
    }

    public void setFileNameExpression(Expression fileNameExpression) {
        this.assertRemoteFileTemplateMutability("fileNameExpression");
        this.remoteFileTemplate.setFileNameExpression(fileNameExpression);
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.assertRemoteFileTemplateMutability("useTemporaryFileName");
        this.remoteFileTemplate.setUseTemporaryFileName(useTemporaryFileName);
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.assertRemoteFileTemplateMutability("fileNameGenerator");
        this.remoteFileTemplate.setFileNameGenerator(fileNameGenerator);
    }

    public void setCharset(String charset) {
        this.assertRemoteFileTemplateMutability("charset");
        this.remoteFileTemplate.setCharset(charset);
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
        boolean bl = this.filterAfterEnhancement = filter != null && filter.isForRecursion() && filter.supportsSingleFileFiltering() && this.options.contains((Object)Option.RECURSIVE);
        if (filter != null && !filter.isForRecursion()) {
            this.logger.warn((CharSequence)"When using recursion, you will normally want to set the filter's 'forRecursion' property; otherwise files added deep into the directory tree may not be detected");
        }
    }

    public void setMputFilter(FileListFilter<File> filter) {
        this.mputFilter = filter;
    }

    public void setRenameExpression(Expression renameExpression) {
        this.renameProcessor = new ExpressionEvaluatingMessageProcessor(renameExpression);
    }

    public void setRenameExpressionString(String renameExpression) {
        Assert.hasText((String)renameExpression, (String)"'renameExpression' cannot be empty");
        this.setRenameExpression(EXPRESSION_PARSER.parseExpression(renameExpression));
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setLocalFilenameGeneratorExpressionString(String localFilenameGeneratorExpression) {
        Assert.hasText((String)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be empty");
        this.localFilenameGeneratorExpression = EXPRESSION_PARSER.parseExpression(localFilenameGeneratorExpression);
    }

    public void setFileExistsModeExpression(Expression fileExistsModeExpression) {
        Assert.notNull((Object)fileExistsModeExpression, (String)"'fileExistsModeExpression' must not be null");
        this.fileExistsModeExpression = fileExistsModeExpression;
    }

    public void setFileExistsModeExpressionString(String fileExistsModeExpression) {
        Assert.hasText((String)fileExistsModeExpression, (String)"'fileExistsModeExpression' must not be empty");
        this.fileExistsModeExpression = EXPRESSION_PARSER.parseExpression(fileExistsModeExpression);
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        this.fileExistsMode = fileExistsMode;
    }

    public void setChmodOctal(String chmod) {
        Assert.notNull((Object)chmod, (String)"'chmod' cannot be null");
        this.setChmod(Integer.parseInt(chmod, 8));
    }

    public void setChmod(int chmod) {
        Assert.isTrue((boolean)this.isChmodCapable(), (String)"chmod operations not supported");
        this.chmod = chmod;
    }

    public boolean isChmodCapable() {
        return false;
    }

    protected final RemoteFileTemplate<F> getRemoteFileTemplate() {
        return this.remoteFileTemplate;
    }

    protected void doInit() {
        Assert.state((this.command != null || this.messageSessionCallback != null ? 1 : 0) != 0, (String)"'command' or 'messageSessionCallback' must be specified.");
        if (Command.RM.equals((Object)this.command) || Command.GET.equals((Object)this.command)) {
            Assert.isNull(this.filter, (String)"Filters are not supported with the rm and get commands");
        }
        this.standardEvaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (Command.GET.equals((Object)this.command) && !this.options.contains((Object)Option.STREAM) || Command.MGET.equals((Object)this.command)) {
            Assert.notNull((Object)this.localDirectoryExpression, (String)"localDirectory must not be null");
            if (this.localDirectoryExpression instanceof ValueExpression) {
                this.setupLocalDirectory();
            }
        }
        if (Command.MGET.equals((Object)this.command)) {
            Assert.isTrue((!this.options.contains((Object)Option.SUBDIRS) ? 1 : 0) != 0, () -> "Cannot use " + Option.SUBDIRS.toString() + " when using 'mget' use " + Option.RECURSIVE.toString() + " to obtain files in subdirectories");
        }
        if (FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && this.remoteFileTemplate.isUseTemporaryFileName()) {
            this.logger.warn((CharSequence)"FileExistsMode.APPEND is incompatible with useTemporaryFileName=true. Temporary filename will be ignored for APPEND mode.");
        }
        this.populateBeanFactoryIntoComponentsIfAny();
        if (!this.remoteFileTemplateExplicitlySet) {
            this.remoteFileTemplate.afterPropertiesSet();
        }
    }

    private void populateBeanFactoryIntoComponentsIfAny() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            if (this.fileNameProcessor != null) {
                this.fileNameProcessor.setBeanFactory(beanFactory);
            }
            this.renameProcessor.setBeanFactory(beanFactory);
            this.remoteFileTemplate.setBeanFactory(beanFactory);
        }
    }

    private void setupLocalDirectory() {
        block5: {
            File localDirectory = ExpressionUtils.expressionToFile((Expression)this.localDirectoryExpression, (EvaluationContext)this.standardEvaluationContext, null, (String)"localDirectoryExpression");
            if (!localDirectory.exists()) {
                try {
                    if (this.autoCreateLocalDirectory) {
                        this.logger.debug(() -> "The '" + String.valueOf(localDirectory) + "' directory doesn't exist; Will create.");
                        if (!localDirectory.mkdirs()) {
                            throw new IOException("Failed to make local directory: " + String.valueOf(localDirectory));
                        }
                        break block5;
                    }
                    throw new FileNotFoundException(localDirectory.getName());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.command != null) {
            return switch (this.command.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.doLs(requestMessage);
                case 1 -> this.doNlst(requestMessage);
                case 2 -> this.doGet(requestMessage);
                case 4 -> this.doMget(requestMessage);
                case 3 -> this.doRm(requestMessage);
                case 5 -> this.doMv(requestMessage);
                case 6 -> this.doPut(requestMessage);
                case 7 -> this.doMput(requestMessage);
            };
        }
        return this.remoteFileTemplate.execute(session -> this.messageSessionCallback.doInSession(session, requestMessage));
    }

    private Object doLs(Message<?> requestMessage) {
        String dir = this.obtainRemoteDir(requestMessage);
        return this.remoteFileTemplate.execute(session -> {
            List<?> payload = this.ls(requestMessage, session, dir);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)dir).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private Object doNlst(Message<?> requestMessage) {
        String dir = this.obtainRemoteDir(requestMessage);
        return this.remoteFileTemplate.execute(session -> {
            List<String> payload = this.nlst(requestMessage, session, dir);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)dir).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private String obtainRemoteDir(Message<?> requestMessage) {
        Object dir;
        Object object = dir = this.fileNameProcessor != null ? (String)this.fileNameProcessor.processMessage(requestMessage) : null;
        if (dir != null && !((String)dir).endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = (String)dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        return dir;
    }

    protected List<String> nlst(Message<?> message, Session<F> session, String dir) throws IOException {
        String remoteDirectory = this.buildRemotePath(dir, "");
        List<String> fileNames = Arrays.asList(session.listNames(remoteDirectory));
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(fileNames);
        }
        return fileNames;
    }

    private Object doGet(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        if (this.options.contains((Object)Option.STREAM)) {
            Session<F> session = this.remoteFileTemplate.getSessionFactory().getSession();
            try {
                InputStream payload = session.readRaw(remoteFilePath);
                return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort()).setHeader("closeableResource", session);
            }
            catch (IOException e) {
                session.close();
                throw new MessageHandlingException(requestMessage, "Error handling message in the [" + String.valueOf((Object)this) + "]. Failed to get the remote file [" + remoteFilePath + "] as a stream", (Throwable)e);
            }
        }
        return this.remoteFileTemplate.execute(session1 -> {
            File getPayload = this.get(requestMessage, session1, remoteDir, remoteFilePath, remoteFilename, null);
            return this.getMessageBuilderFactory().withPayload((Object)getPayload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session1.getHostPort());
        });
    }

    private Object doMget(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        return this.remoteFileTemplate.execute(session -> {
            List<File> payload = this.mGet(requestMessage, session, remoteDir, remoteFilename);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private Object doRm(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        return this.remoteFileTemplate.execute(session -> {
            boolean payload = this.rm(requestMessage, session, remoteFilePath);
            return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    protected boolean rm(Message<?> message, Session<F> session, String remoteFilePath) throws IOException {
        return session.remove(remoteFilePath);
    }

    private Object doMv(Message<?> requestMessage) {
        MessageProcessor<String> directoryExpressionProcessor;
        String remoteFilename;
        Object remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteDir = this.getRemoteDirectory((String)remoteFilePath, remoteFilename = this.getRemoteFilename((String)remoteFilePath));
        if (remoteDir == null && (directoryExpressionProcessor = this.remoteFileTemplate.getDirectoryExpressionProcessor()) != null && (remoteDir = (String)directoryExpressionProcessor.processMessage(requestMessage)) != null) {
            remoteFilePath = remoteDir + this.remoteFileTemplate.getRemoteFileSeparator() + remoteFilename;
        }
        String remoteFileNewPath = this.buildRemoteFileNewPath(requestMessage, remoteDir);
        Assert.hasLength((String)remoteFileNewPath, (String)"New filename cannot be empty");
        return this.executeMv(requestMessage, remoteFilename, remoteDir, (String)remoteFilePath, remoteFileNewPath);
    }

    private String obtainRemoteFilePath(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        Assert.state((remoteFilePath != null ? 1 : 0) != 0, () -> "The 'fileNameProcessor' evaluated to null 'remoteFilePath' from message: " + String.valueOf(requestMessage));
        return remoteFilePath;
    }

    private String buildRemoteFileNewPath(Message<?> requestMessage, @Nullable String remoteDir) {
        String remoteFilename;
        String dir;
        Object remoteFileNewPath = (String)this.renameProcessor.processMessage(requestMessage);
        Assert.hasLength((String)remoteFileNewPath, (String)"New filename cannot be empty");
        if (remoteDir != null && (dir = this.getRemoteDirectory((String)remoteFileNewPath, remoteFilename = this.getRemoteFilename((String)remoteFileNewPath))) == null) {
            remoteFileNewPath = remoteDir + this.remoteFileTemplate.getRemoteFileSeparator() + remoteFilename;
        }
        return remoteFileNewPath;
    }

    private AbstractIntegrationMessageBuilder<Boolean> executeMv(Message<?> requestMessage, String remoteFilename, String remoteDir, String remoteFilePath, String remoteFileNewPath) {
        return this.remoteFileTemplate.execute(session -> {
            Boolean result = this.mv(requestMessage, session, remoteFilePath, remoteFileNewPath);
            return this.getMessageBuilderFactory().withPayload((Object)result).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_renameTo", (Object)remoteFileNewPath).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    protected boolean mv(Message<?> message, Session<F> session, String remoteFilePath, String remoteFileNewPath) throws IOException {
        int lastSeparator = remoteFileNewPath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (lastSeparator > 0) {
            String remoteFileDirectory = remoteFileNewPath.substring(0, lastSeparator + 1);
            RemoteFileUtils.makeDirectories(remoteFileDirectory, session, this.remoteFileTemplate.getRemoteFileSeparator(), this.logger.getLog());
        }
        session.rename(remoteFilePath, remoteFileNewPath);
        return true;
    }

    private String doPut(Message<?> requestMessage) {
        return this.doPut(requestMessage, null);
    }

    private String doPut(Message<?> requestMessage, String subDirectory) {
        return this.remoteFileTemplate.invoke(template -> this.put(requestMessage, template.getSession(), subDirectory));
    }

    protected String put(Message<?> message, Session<F> session, String subDirectory) {
        FileExistsMode existsMode = this.resolveFileExistsMode(message);
        String path = this.remoteFileTemplate.send(message, subDirectory, new FileExistsMode[]{existsMode});
        if (path == null) {
            throw new MessagingException(message, "No local file found for " + String.valueOf(message));
        }
        if (this.chmod != null && this.isChmodCapable()) {
            this.doChmod(this.remoteFileTemplate, path, this.chmod);
        }
        return path;
    }

    protected void doChmod(RemoteFileOperations<F> remoteFileOperations, String path, int chmodToSet) {
    }

    private Object doMput(Message<?> requestMessage) {
        File file = null;
        Object payload = requestMessage.getPayload();
        if (payload instanceof File) {
            File filePayload2;
            file = filePayload2 = (File)payload;
        } else if (payload instanceof String) {
            String fileName = (String)payload;
            file = new File(fileName);
        } else if (!(payload instanceof Collection)) {
            throw new IllegalArgumentException("Only File or String payloads (or Collection of File/String) allowed for 'mput', received: " + String.valueOf(payload.getClass()));
        }
        if (payload instanceof Collection) {
            Collection files = (Collection)payload;
            return files.stream().map(filePayload -> AbstractRemoteFileOutboundGateway.mputItemMessage(filePayload, requestMessage.getHeaders())).map(this::doMput).collect(Collectors.toList());
        }
        if (!file.isDirectory()) {
            return this.doPut(requestMessage);
        }
        File localDir = file;
        return this.remoteFileTemplate.invoke(t -> this.mPut(requestMessage, t.getSession(), localDir));
    }

    private static Message<?> mputItemMessage(Object payload, MessageHeaders requestHeaders) {
        return MutableMessageBuilder.withPayload((Object)payload).copyHeaders((Map)requestHeaders).removeHeader("file_name").build();
    }

    protected List<String> mPut(Message<?> message, Session<F> session, File localDir) {
        return this.putLocalDirectory(message, localDir, null);
    }

    private List<String> putLocalDirectory(Message<?> requestMessage, File file, String subDirectory) {
        List<File> filteredFiles = this.filterMputFiles(file.listFiles());
        ArrayList<String> replies = new ArrayList<String>();
        try {
            for (File filteredFile : filteredFiles) {
                if (!filteredFile.isDirectory()) {
                    String path = this.doPut(AbstractRemoteFileOutboundGateway.mputItemMessage(filteredFile, requestMessage.getHeaders()), subDirectory);
                    if (path != null) {
                        replies.add(path);
                        continue;
                    }
                    this.logger.debug(() -> "File " + filteredFile.getAbsolutePath() + " removed before transfer; ignoring");
                    continue;
                }
                if (!this.options.contains((Object)Option.RECURSIVE)) continue;
                String newSubDirectory = (String)(StringUtils.hasText((String)subDirectory) ? subDirectory + this.remoteFileTemplate.getRemoteFileSeparator() : "") + filteredFile.getName();
                replies.addAll(this.putLocalDirectory(requestMessage, filteredFile, newSubDirectory));
            }
        }
        catch (RuntimeException ex) {
            throw this.handlePutException(requestMessage, subDirectory, filteredFiles, replies, ex);
        }
        return replies;
    }

    private RuntimeException handlePutException(Message<?> requestMessage, String subDirectory, List<File> filteredFiles, List<String> replies, RuntimeException ex) {
        if (!replies.isEmpty() || ex instanceof PartialSuccessException) {
            return new PartialSuccessException(requestMessage, "Partially successful 'mput' operation" + (String)(subDirectory == null ? "" : " on " + subDirectory), (Throwable)ex, replies, filteredFiles);
        }
        return ex;
    }

    protected List<?> ls(Message<?> message, Session<F> session, String dir) throws IOException {
        List<F> lsFiles = this.listFilesInRemoteDir(session, dir, "");
        if (!this.options.contains((Object)Option.LINKS)) {
            this.purgeLinks(lsFiles);
        }
        if (!this.options.contains((Object)Option.ALL)) {
            this.purgeDots(lsFiles);
        }
        if (this.options.contains((Object)Option.NAME_ONLY)) {
            ArrayList<String> results = new ArrayList<String>();
            for (F file : lsFiles) {
                results.add(this.getFilename(file));
            }
            if (!this.options.contains((Object)Option.NOSORT)) {
                Collections.sort(results);
            }
            return results;
        }
        List<AbstractFileInfo<F>> canonicalFiles = this.asFileInfoList(lsFiles);
        for (AbstractFileInfo<F> file : canonicalFiles) {
            file.setRemoteDirectory(dir);
        }
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(canonicalFiles);
        }
        return canonicalFiles;
    }

    private List<F> listFilesInRemoteDir(Session<F> session, String directory, String subDirectory) throws IOException {
        ArrayList lsFiles = new ArrayList();
        String remoteDirectory = this.buildRemotePath(directory, subDirectory);
        F[] list = session.list(remoteDirectory);
        List<F> files = !this.filterAfterEnhancement ? this.filterFiles(list) : Arrays.asList(list);
        if (!ObjectUtils.isEmpty(files)) {
            for (F file : files) {
                if (file == null) continue;
                this.processFile(session, directory, subDirectory, lsFiles, this.options.contains((Object)Option.RECURSIVE), file);
            }
        }
        return lsFiles;
    }

    private String buildRemotePath(String parent, String child) {
        String remotePath = null;
        if (parent != null) {
            remotePath = parent + child;
        } else if (StringUtils.hasText((String)child)) {
            remotePath = "." + this.remoteFileTemplate.getRemoteFileSeparator() + child;
        }
        return remotePath;
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected final F filterFile(F file) {
        if (this.filter.accept(file)) {
            return file;
        }
        return null;
    }

    private void processFile(Session<F> session, String directory, String subDirectory, List<F> lsFiles, boolean recursion, F file) throws IOException {
        F fileToAdd = file;
        if (recursion && StringUtils.hasText((String)subDirectory)) {
            fileToAdd = this.enhanceNameWithSubDirectory(file, subDirectory);
        }
        if (this.filterAfterEnhancement && !this.filter.accept(fileToAdd)) {
            return;
        }
        Object fileName = this.getFilename(fileToAdd);
        if (StringUtils.hasText((String)subDirectory) && !((String)fileName).startsWith(subDirectory)) {
            fileName = subDirectory + (String)fileName;
        }
        boolean isDirectory = this.isDirectory(file);
        boolean isDots = this.hasDots((String)fileName);
        if (!(!this.options.contains((Object)Option.SUBDIRS) && isDirectory || isDots && !this.options.contains((Object)Option.ALL))) {
            lsFiles.add(fileToAdd);
        }
        if (recursion && isDirectory && !isDots) {
            lsFiles.addAll(this.listFilesInRemoteDir(session, directory, (String)fileName + this.remoteFileTemplate.getRemoteFileSeparator()));
        }
    }

    private boolean hasDots(String fileName) {
        String fileSeparator = this.remoteFileTemplate.getRemoteFileSeparator();
        return ".".equals(fileName) || "..".equals(fileName) || fileName.endsWith(fileSeparator + ".") || fileName.endsWith(fileSeparator + "..");
    }

    protected final List<File> filterMputFiles(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        return this.mputFilter != null ? this.mputFilter.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected void purgeLinks(List<F> lsFiles) {
        lsFiles.removeIf(this::isLink);
    }

    protected void purgeDots(List<F> lsFiles) {
        lsFiles.removeIf(f -> this.getFilename(f).startsWith("."));
    }

    protected File get(Message<?> message, Session<F> session, String remoteDir, String remoteFilePath, String remoteFilename, F fileInfoParam) throws IOException {
        boolean replacing;
        F fileInfo = fileInfoParam;
        if (fileInfo == null) {
            F[] files = session.list(remoteFilePath);
            if (files == null) {
                throw new MessagingException("Session returned null when listing " + remoteFilePath);
            }
            if (files.length != 1 || files[0] == null || this.isDirectory(files[0]) || this.isLink(files[0])) {
                throw new MessagingException(remoteFilePath + " is not a file");
            }
            fileInfo = files[0];
        }
        File localFile = new File(this.generateLocalDirectory(message, remoteDir), this.generateLocalFileName(message, remoteFilename));
        FileExistsMode existsMode = this.resolveFileExistsMode(message);
        boolean appending = FileExistsMode.APPEND.equals((Object)existsMode);
        boolean exists = localFile.exists();
        boolean bl = replacing = exists && (FileExistsMode.REPLACE.equals((Object)existsMode) || FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode) && localFile.lastModified() != this.getModified(fileInfo));
        if (!exists || appending || replacing) {
            String tempFileName = localFile.getAbsolutePath() + this.remoteFileTemplate.getTemporaryFileSuffix();
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = appending ? new BufferedOutputStream(new FileOutputStream(localFile, true)) : new BufferedOutputStream(new FileOutputStream(tempFile));
            if (replacing && !localFile.delete()) {
                this.logger.warn(() -> "Failed to delete " + String.valueOf(localFile));
            }
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception ex) {
                ((OutputStream)outputStream).close();
                if (!tempFile.delete()) {
                    this.logger.warn(() -> "Failed to delete tempFile " + String.valueOf(tempFile));
                }
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Failure occurred while copying from remote to local directory", (Throwable)ex);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
            if (!appending && !tempFile.renameTo(localFile)) {
                throw new MessagingException("Failed to rename local file");
            }
            if ((this.options.contains((Object)Option.PRESERVE_TIMESTAMP) || FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode)) && !localFile.setLastModified(this.getModified(fileInfo))) {
                this.logger.warn(() -> "Failed to set lastModified on " + String.valueOf(localFile));
            }
            if (this.options.contains((Object)Option.DELETE)) {
                boolean result = session.remove(remoteFilePath);
                if (!result) {
                    this.logger.error((CharSequence)("Failed to delete: " + remoteFilePath));
                } else {
                    this.logger.debug(() -> remoteFilePath + " deleted");
                }
            }
        } else if (FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode)) {
            this.logger.debug(() -> "Local file '" + String.valueOf(localFile) + "' has the same modified timestamp, ignored");
            if (this.command.equals((Object)Command.MGET)) {
                return null;
            }
        } else {
            if (!FileExistsMode.IGNORE.equals((Object)existsMode)) {
                throw new MessageHandlingException(message, "Error handling message in the [" + String.valueOf((Object)this) + "]. Local file " + String.valueOf(localFile) + " already exists");
            }
            this.logger.debug(() -> "Existing file skipped: " + String.valueOf(localFile));
            if (this.command.equals((Object)Command.MGET)) {
                return null;
            }
        }
        return localFile;
    }

    protected List<File> mGet(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        if (this.options.contains((Object)Option.RECURSIVE)) {
            if (!"*".equals(remoteFilename)) {
                this.logger.warn((CharSequence)"File name pattern must be '*' when using recursion");
            }
            this.options.remove((Object)Option.NAME_ONLY);
            return this.mGetWithRecursion(message, session, remoteDirectory, remoteFilename);
        }
        return this.mGetWithoutRecursion(message, session, remoteDirectory, remoteFilename);
    }

    private List<File> mGetWithoutRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        String remotePath = this.buildRemotePath(remoteDirectory, remoteFilename);
        List<AbstractFileInfo<F>> remoteFiles = this.lsRemoteFilesForMget(message, session, remoteDirectory, remoteFilename, remotePath);
        try {
            for (AbstractFileInfo<F> lsEntry : remoteFiles) {
                File file;
                if (lsEntry.isDirectory() || (file = this.getRemoteFileForMget(message, session, remoteDirectory, lsEntry)) == null) continue;
                files.add(file);
            }
        }
        catch (Exception ex) {
            throw this.processMgetException(message, remoteDirectory, files, remoteFiles, ex);
        }
        return files;
    }

    private RuntimeException processMgetException(Message<?> message, String remoteDirectory, List<File> files, List<AbstractFileInfo<F>> remoteFiles, Exception ex) {
        if (!files.isEmpty()) {
            return new PartialSuccessException(message, "Partially successful recursive 'mget' operation on " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory"), (Throwable)ex, files, remoteFiles);
        }
        if (ex instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)ex;
            return messagingException;
        }
        if (ex instanceof IOException) {
            IOException ioException = (IOException)ex;
            throw new UncheckedIOException(ioException);
        }
        return new MessagingException("Failed to process MGET", (Throwable)ex);
    }

    private List<File> mGetWithRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        List<AbstractFileInfo<F>> fileNames = this.lsRemoteFilesForMget(message, session, remoteDirectory, remoteFilename, remoteDirectory);
        try {
            for (AbstractFileInfo<F> lsEntry : fileNames) {
                File file = this.getRemoteFileForMget(message, session, remoteDirectory, lsEntry);
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (Exception ex) {
            throw this.processMgetException(message, remoteDirectory, files, fileNames, ex);
        }
        return files;
    }

    private List<AbstractFileInfo<F>> lsRemoteFilesForMget(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename, String remotePath) throws IOException {
        List<AbstractFileInfo<F>> remoteFiles = this.ls(message, session, remotePath);
        if (remoteFiles.isEmpty() && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory") + " with pattern " + remoteFilename);
        }
        return remoteFiles;
    }

    private File getRemoteFileForMget(Message<?> message, Session<F> session, String remoteDirectory, AbstractFileInfo<F> lsEntry) throws IOException {
        String fullFileName = this.getFullFileName(remoteDirectory, lsEntry.getFileInfo());
        String fileName = this.getRemoteFilename(fullFileName);
        String actualRemoteDirectory = this.getRemoteDirectory(fullFileName, fileName);
        return this.get(message, session, actualRemoteDirectory, fullFileName, fileName, lsEntry.getFileInfo());
    }

    protected String getFullFileName(String remoteDirectory, F remoteFile) {
        return remoteDirectory != null ? remoteDirectory + this.getFilename(remoteFile) : this.getFilename(remoteFile);
    }

    private String getRemoteDirectory(String remoteFilePath, String remoteFilename) {
        String remoteDir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(remoteFilename));
        if (remoteDir.isEmpty()) {
            return null;
        }
        return remoteDir;
    }

    protected String getRemoteFilename(String remoteFilePath) {
        int index = remoteFilePath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (index < 0) {
            return remoteFilePath;
        }
        return remoteFilePath.substring(index + 1);
    }

    private FileExistsMode resolveFileExistsMode(Message<?> message) {
        if (this.fileExistsModeExpression != null) {
            Object evaluationResult = this.fileExistsModeExpression.getValue(this.standardEvaluationContext, message);
            if (evaluationResult instanceof FileExistsMode) {
                FileExistsMode resolvedMode = (FileExistsMode)((Object)evaluationResult);
                return resolvedMode;
            }
            if (evaluationResult instanceof String) {
                String modeAsString = (String)evaluationResult;
                try {
                    return FileExistsMode.valueOf(modeAsString.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new MessagingException(message, "Invalid FileExistsMode string: '" + modeAsString + "'. Expected one of: " + Arrays.toString((Object[])FileExistsMode.values()), (Throwable)ex);
                }
            }
            if (evaluationResult != null) {
                throw new MessagingException(message, "Expression returned invalid type for FileExistsMode: " + evaluationResult.getClass().getName() + ". Expected FileExistsMode or String.");
            }
        }
        return this.fileExistsMode;
    }

    private File generateLocalDirectory(Message<?> message, String remoteDirectory) {
        File localDir;
        StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (remoteDirectory != null) {
            evaluationContext.setVariable("remoteDirectory", (Object)remoteDirectory);
        }
        if (!(localDir = ExpressionUtils.expressionToFile((Expression)this.localDirectoryExpression, (EvaluationContext)evaluationContext, message, (String)"Local Directory")).exists()) {
            Assert.isTrue((boolean)localDir.mkdirs(), () -> "Failed to make local directory: " + String.valueOf(localDir));
        }
        return localDir;
    }

    private String generateLocalFileName(Message<?> message, String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
            evaluationContext.setVariable("remoteFileName", (Object)remoteFileName);
            return (String)this.localFilenameGeneratorExpression.getValue((EvaluationContext)evaluationContext, message, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isDirectory(F var1);

    protected abstract boolean isLink(F var1);

    protected abstract String getFilename(F var1);

    protected abstract String getFilename(AbstractFileInfo<F> var1);

    protected abstract long getModified(F var1);

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract F enhanceNameWithSubDirectory(F var1, String var2);

    public static enum Command {
        LS("ls"),
        NLST("nlst"),
        GET("get"),
        RM("rm"),
        MGET("mget"),
        MV("mv"),
        PUT("put"),
        MPUT("mput");

        private final String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Command toCommand(String cmd) {
            for (Command command : Command.values()) {
                if (!command.getCommand().equals(cmd)) continue;
                return command;
            }
            throw new IllegalArgumentException("No Command with value '" + cmd + "'");
        }
    }

    public static enum Option {
        NAME_ONLY("-1"),
        ALL("-a"),
        NOSORT("-f"),
        SUBDIRS("-dirs"),
        LINKS("-links"),
        PRESERVE_TIMESTAMP("-P"),
        EXCEPTION_WHEN_EMPTY("-x"),
        RECURSIVE("-R"),
        STREAM("-stream"),
        DELETE("-D");

        private final String option;

        private Option(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }

        public static Option toOption(String opt) {
            for (Option option : Option.values()) {
                if (!option.getOption().equals(opt)) continue;
                return option;
            }
            throw new IllegalArgumentException("No option with value '" + opt + "'");
        }
    }
}

