/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.List;
import org.springframework.integration.file.filters.AbstractDirectoryAwareFileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractPersistentAcceptOnceFileListFilter<F>
extends AbstractDirectoryAwareFileListFilter<F>
implements ReversibleFileListFilter<F>,
ResettableFileListFilter<F>,
Closeable {
    protected final ConcurrentMetadataStore store;
    protected final String prefix;
    @Nullable
    protected final Flushable flushableStore;
    protected boolean flushOnUpdate;

    public AbstractPersistentAcceptOnceFileListFilter(ConcurrentMetadataStore store, String prefix) {
        Flushable flushable;
        Assert.notNull((Object)store, (String)"'store' cannot be null");
        Assert.notNull((Object)prefix, (String)"'prefix' cannot be null");
        this.store = store;
        this.prefix = prefix;
        this.flushableStore = store instanceof Flushable ? (flushable = (Flushable)store) : null;
    }

    public void setFlushOnUpdate(boolean flushOnUpdate) {
        this.flushOnUpdate = flushOnUpdate;
    }

    @Override
    public boolean accept(F file) {
        String newValue;
        if (this.alwaysAccept(file)) {
            return true;
        }
        String key = this.buildKey(file);
        String oldValue = this.store.putIfAbsent(key, newValue = this.value(file));
        if (oldValue == null) {
            this.flushIfNeeded();
            return this.fileStillExists(file);
        }
        if (!this.isEqual(file, oldValue) && this.store.replace(key, oldValue, newValue)) {
            this.flushIfNeeded();
            return this.fileStillExists(file);
        }
        return false;
    }

    protected boolean fileStillExists(F file) {
        return true;
    }

    @Override
    public void rollback(F file, List<F> files) {
        boolean rollingBack = false;
        for (F fileToRollback : files) {
            if (fileToRollback.equals(file)) {
                rollingBack = true;
            }
            if (!rollingBack) continue;
            this.remove(fileToRollback);
        }
    }

    @Override
    public boolean remove(F fileToRemove) {
        String removed = this.store.remove(this.buildKey(fileToRemove));
        this.flushIfNeeded();
        return removed != null;
    }

    @Override
    public void close() throws IOException {
        ConcurrentMetadataStore concurrentMetadataStore = this.store;
        if (concurrentMetadataStore instanceof Closeable) {
            Closeable closeable = (Closeable)concurrentMetadataStore;
            closeable.close();
        }
    }

    private String value(F file) {
        return Long.toString(this.modified(file));
    }

    protected boolean isEqual(F file, String value) {
        return Long.parseLong(value) == this.modified(file);
    }

    protected String buildKey(F file) {
        return this.prefix + this.fileName(file);
    }

    protected void flushIfNeeded() {
        if (this.flushOnUpdate && this.flushableStore != null) {
            try {
                this.flushableStore.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean isDirectory(F file) {
        return false;
    }

    protected abstract long modified(F var1);

    protected abstract String fileName(F var1);
}

