/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import java.util.Comparator;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.file.dsl.FileInboundChannelAdapterSpec;
import org.springframework.integration.file.dsl.FileSplitterSpec;
import org.springframework.integration.file.dsl.FileWritingMessageHandlerSpec;
import org.springframework.integration.file.dsl.TailAdapterSpec;
import org.springframework.integration.file.transformer.FileToByteArrayTransformer;
import org.springframework.integration.file.transformer.FileToStringTransformer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public abstract class Files {
    public static FileInboundChannelAdapterSpec inboundAdapter(File directory) {
        return Files.inboundAdapter(directory, null);
    }

    public static FileInboundChannelAdapterSpec inboundAdapter(File directory, @Nullable Comparator<File> receptionOrderComparator) {
        return new FileInboundChannelAdapterSpec(receptionOrderComparator).directory(directory);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(File destinationDirectory) {
        return new FileWritingMessageHandlerSpec(destinationDirectory).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(String directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(Expression directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(false);
    }

    public static <P> FileWritingMessageHandlerSpec outboundAdapter(Function<Message<P>, ?> directoryFunction) {
        return new FileWritingMessageHandlerSpec(directoryFunction).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(File destinationDirectory) {
        return new FileWritingMessageHandlerSpec(destinationDirectory).expectReply(true);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(String directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(true);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(Expression directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(true);
    }

    public static <P> FileWritingMessageHandlerSpec outboundGateway(Function<Message<P>, ?> directoryFunction) {
        return new FileWritingMessageHandlerSpec(directoryFunction).expectReply(true);
    }

    public static TailAdapterSpec tailAdapter(File file) {
        return new TailAdapterSpec().file(file);
    }

    public static FileSplitterSpec splitter() {
        return Files.splitter(true);
    }

    public static FileSplitterSpec splitter(boolean iterator) {
        return Files.splitter(iterator, false);
    }

    public static FileSplitterSpec splitter(boolean iterator, boolean markers) {
        return new FileSplitterSpec(iterator, markers);
    }

    public static FileToStringTransformer toStringTransformer() {
        return Files.toStringTransformer(false);
    }

    public static FileToStringTransformer toStringTransformer(boolean deleteFiles) {
        return Files.toStringTransformer(null, deleteFiles);
    }

    public static FileToStringTransformer toStringTransformer(String charset) {
        return Files.toStringTransformer(charset, false);
    }

    public static FileToStringTransformer toStringTransformer(@Nullable String charset, boolean deleteFiles) {
        FileToStringTransformer transformer = new FileToStringTransformer();
        if (charset != null) {
            transformer.setCharset(charset);
        }
        transformer.setDeleteFiles(deleteFiles);
        return transformer;
    }

    public static FileToByteArrayTransformer toByteArrayTransformer() {
        return Files.toByteArrayTransformer(false);
    }

    public static FileToByteArrayTransformer toByteArrayTransformer(boolean deleteFiles) {
        FileToByteArrayTransformer fileToByteArrayTransformer = new FileToByteArrayTransformer();
        fileToByteArrayTransformer.setDeleteFiles(deleteFiles);
        return fileToByteArrayTransformer;
    }
}

