/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractInboundFileSynchronizer<F>
implements InboundFileSynchronizer,
BeanFactoryAware,
BeanNameAware,
InitializingBean,
Closeable {
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private EvaluationContext evaluationContext;
    private String remoteFileSeparator = "/";
    private String temporaryFileSuffix = ".writing";
    private Expression localFilenameGeneratorExpression;
    private Expression remoteDirectoryExpression;
    @Nullable
    private FileListFilter<F> filter;
    private boolean deleteRemoteFiles;
    private boolean preserveTimestamp;
    private BeanFactory beanFactory;
    @Nullable
    private Comparator<? extends F> comparator;
    private MetadataStore remoteFileMetadataStore = new SimpleMetadataStore();
    private String metadataStorePrefix;
    private String name;

    public AbstractInboundFileSynchronizer(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
    }

    @Nullable
    protected Comparator<? extends F> getComparator() {
        return this.comparator;
    }

    public void setComparator(@Nullable Comparator<? extends F> comparator) {
        this.comparator = comparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setLocalFilenameGeneratorExpressionString(String localFilenameGeneratorExpression) {
        this.setLocalFilenameGeneratorExpression(EXPRESSION_PARSER.parseExpression(localFilenameGeneratorExpression));
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.doSetRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    public void setRemoteDirectoryExpressionString(String remoteDirectoryExpression) {
        this.doSetRemoteDirectoryExpression(EXPRESSION_PARSER.parseExpression(remoteDirectoryExpression));
    }

    protected final void doSetRemoteDirectoryExpression(Expression expression) {
        Assert.notNull((Object)expression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = expression;
    }

    public void setFilter(@Nullable FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(@Nullable FileListFilter<F> filterToSet) {
        this.filter = filterToSet;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setRemoteFileMetadataStore(MetadataStore remoteFileMetadataStore) {
        this.remoteFileMetadataStore = remoteFileMetadataStore;
    }

    public void setMetadataStorePrefix(String metadataStorePrefix) {
        this.metadataStorePrefix = metadataStorePrefix;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public final void afterPropertiesSet() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
        if (!StringUtils.hasText((String)this.metadataStorePrefix)) {
            this.metadataStorePrefix = this.name;
        }
        this.doInit();
    }

    protected void doInit() {
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    @Override
    public void close() throws IOException {
        if (this.filter instanceof Closeable) {
            ((Closeable)((Object)this.filter)).close();
        }
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory) {
        this.synchronizeToLocalDirectory(localDirectory, Integer.MIN_VALUE);
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory, int maxFetchSize) {
        if (maxFetchSize == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Max Fetch Size is zero - fetch to " + localDirectory.getAbsolutePath() + " ignored"));
            }
            return;
        }
        String remoteDirectory = (String)this.remoteDirectoryExpression.getValue(this.evaluationContext, String.class);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Synchronizing " + remoteDirectory + " to " + localDirectory));
        }
        try {
            int transferred = this.remoteFileTemplate.execute(session -> this.transferFilesFromRemoteToLocal(remoteDirectory, localDirectory, maxFetchSize, session));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(transferred + " files transferred from '" + remoteDirectory + "'"));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Problem occurred while synchronizing '" + remoteDirectory + "' to local directory", (Throwable)e);
        }
    }

    private Integer transferFilesFromRemoteToLocal(String remoteDirectory, File localDirectory, int maxFetchSize, Session<F> session) throws IOException {
        Object[] files = session.list(remoteDirectory);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            files = FileUtils.purgeUnwantedElements(files, e -> !this.isFile(e), this.comparator);
        }
        if (!ObjectUtils.isEmpty((Object[])files)) {
            boolean haveFilter = this.filter != null;
            boolean filteringOneByOne = haveFilter && this.filter.supportsSingleFileFiltering();
            List<Object> filteredFiles = this.applyFilter(files, haveFilter, filteringOneByOne, maxFetchSize);
            int copied = filteredFiles.size();
            int accepted = 0;
            StandardEvaluationContext localFileEvaluationContext = null;
            if (this.localFilenameGeneratorExpression != null) {
                localFileEvaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
                localFileEvaluationContext.setVariable("remoteDirectory", (Object)remoteDirectory);
            }
            for (Object file : filteredFiles) {
                if (filteringOneByOne) {
                    if ((maxFetchSize < 0 || accepted < maxFetchSize) && this.filter.accept(file)) {
                        ++accepted;
                    } else {
                        file = null;
                        --copied;
                    }
                }
                copied = this.copyIfNotNull(remoteDirectory, localDirectory, (EvaluationContext)localFileEvaluationContext, session, filteringOneByOne, filteredFiles, copied, file);
            }
            return copied;
        }
        return 0;
    }

    private int copyIfNotNull(String remoteDirectory, File localDirectory, @Nullable EvaluationContext localFileEvaluationContext, Session<F> session, boolean filteringOneByOne, List<F> filteredFiles, int copied, @Nullable F file) throws IOException {
        boolean renamedFailed = false;
        try {
            if (file != null && !this.copyFileToLocalDirectory(remoteDirectory, localFileEvaluationContext, file, localDirectory, session)) {
                renamedFailed = true;
            }
        }
        catch (IOException | RuntimeException e1) {
            if (filteringOneByOne) {
                this.resetFilterIfNecessary(file);
            } else {
                this.rollbackFromFileToListEnd(filteredFiles, file);
            }
            throw e1;
        }
        return renamedFailed ? copied - 1 : copied;
    }

    private List<F> applyFilter(F[] files, boolean haveFilter, boolean filteringOneByOne, int maxFetchSize) {
        List<Object> filteredFiles = !filteringOneByOne && haveFilter ? this.filterFiles(files) : Arrays.asList(files);
        if (maxFetchSize >= 0 && filteredFiles.size() > maxFetchSize && !filteringOneByOne) {
            if (haveFilter) {
                this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
            }
            filteredFiles = filteredFiles.stream().limit(maxFetchSize).collect(Collectors.toList());
        }
        return filteredFiles;
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected boolean copyFileToLocalDirectory(String remoteDirectoryPath, @Nullable EvaluationContext localFileEvaluationContext, F remoteFile, File localDirectory, Session<F> session) throws IOException {
        String remoteFilePath;
        String remoteFileName = this.getFilename(remoteFile);
        String localFileName = this.generateLocalFileName(remoteFileName, localFileEvaluationContext);
        String string = remoteFilePath = remoteDirectoryPath != null ? remoteDirectoryPath + this.remoteFileSeparator + remoteFileName : remoteFileName;
        if (!this.isFile(remoteFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("cannot copy, not a file: " + remoteFilePath));
            }
            return false;
        }
        long modified = this.getModified(remoteFile);
        File localFile = new File(localDirectory, localFileName);
        boolean exists = localFile.exists();
        if (!exists || this.preserveTimestamp && modified != localFile.lastModified()) {
            if (!exists && localFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                localFile.getParentFile().mkdirs();
            }
            boolean transfer = true;
            if (exists && !localFile.delete()) {
                transfer = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Cannot delete local file '" + localFile + "' in order to transfer modified remote file '" + remoteFile + "'. The local file may be busy in some other process."));
                }
            }
            boolean renamed = false;
            if (transfer) {
                renamed = this.copyRemoteContentToLocalFile(session, remoteFilePath, localFile);
            }
            if (renamed) {
                if (this.deleteRemoteFiles) {
                    session.remove(remoteFilePath);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("deleted remote file: " + remoteFilePath));
                    }
                }
                if (this.preserveTimestamp && !localFile.setLastModified(modified)) {
                    throw new IllegalStateException("Could not sent last modified on file: " + localFile);
                }
                String hostPort = session.getHostPort();
                int colonIndex = hostPort.lastIndexOf(58);
                String host = hostPort.substring(0, colonIndex);
                String port = hostPort.substring(colonIndex + 1);
                try {
                    String remoteFileMetadata = new URI(this.protocol(), null, host, Integer.parseInt(port), "/" + remoteDirectoryPath, null, remoteFileName).toString();
                    this.remoteFileMetadataStore.put(this.buildMetadataKey(localFile), remoteFileMetadata);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("Cannot create a remote file metadata", ex);
                }
                return true;
            }
            this.resetFilterIfNecessary(remoteFile);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The remote file '" + remoteFile + "' has not been transferred to the existing local file '" + localFile + "'. Consider removing the local file."));
        }
        return false;
    }

    private void resetFilterIfNecessary(F remoteFile) {
        if (this.filter instanceof ResettableFileListFilter) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Removing the remote file '" + remoteFile + "' from the filter for a subsequent transfer attempt"));
            }
            ((ResettableFileListFilter)this.filter).remove(remoteFile);
        }
    }

    private boolean copyRemoteContentToLocalFile(Session<F> session, String remoteFilePath, File localFile) {
        String tempFileName = localFile.getAbsolutePath() + this.temporaryFileSuffix;
        File tempFile = new File(tempFileName);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
            session.read(remoteFilePath, outputStream);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("Failure occurred while copying '" + remoteFilePath + "' from the remote to the local directory", (Throwable)e);
        }
        boolean renamed = tempFile.renameTo(localFile);
        if (!renamed) {
            if (localFile.delete()) {
                renamed = tempFile.renameTo(localFile);
                if (!renamed && this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Cannot rename '" + tempFileName + "' to local file '" + localFile + "' after deleting. The local file may be busy in some other process."));
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Cannot delete local file '" + localFile + "'. The local file may be busy in some other process."));
            }
        }
        return renamed;
    }

    private String generateLocalFileName(String remoteFileName, @Nullable EvaluationContext localFileEvaluationContext) {
        if (this.localFilenameGeneratorExpression != null) {
            return (String)this.localFilenameGeneratorExpression.getValue(localFileEvaluationContext, (Object)remoteFileName, String.class);
        }
        return remoteFileName;
    }

    @Nullable
    public String getRemoteFileMetadata(File localFile) {
        String metadataKey = this.buildMetadataKey(localFile);
        return this.remoteFileMetadataStore.get(metadataKey);
    }

    public void removeRemoteFileMetadata(File localFile) {
        String metadataKey = this.buildMetadataKey(localFile);
        this.remoteFileMetadataStore.remove(metadataKey);
    }

    private String buildMetadataKey(File file) {
        return this.metadataStorePrefix + file.getAbsolutePath();
    }

    protected abstract boolean isFile(F var1);

    protected abstract String getFilename(F var1);

    protected abstract long getModified(F var1);

    protected abstract String protocol();
}

