/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;
import org.springframework.lang.Nullable;

public abstract class AbstractLastModifiedFileListFilter<F>
implements DiscardAwareFileListFilter<F> {
    protected static final long ONE_SECOND = 1000L;
    private static final long DEFAULT_AGE = 60L;
    private Duration age = Duration.ofSeconds(60L);
    @Nullable
    private Consumer<F> discardCallback;

    public AbstractLastModifiedFileListFilter() {
    }

    public AbstractLastModifiedFileListFilter(Duration age) {
        this.age = age;
    }

    public void setAge(Duration age) {
        this.age = age;
    }

    public void setAge(long age) {
        this.setAge(Duration.ofSeconds(age));
    }

    @Override
    public void addDiscardCallback(@Nullable Consumer<F> discardCallback) {
        this.discardCallback = discardCallback;
    }

    @Override
    public List<F> filterFiles(F[] files) {
        ArrayList<F> list = new ArrayList<F>();
        Instant now = Instant.now();
        for (F file : files) {
            if (this.fileIsAged(file, now)) {
                list.add(file);
                continue;
            }
            if (this.discardCallback == null) continue;
            this.discardCallback.accept(file);
        }
        return list;
    }

    @Override
    public boolean accept(F file) {
        if (this.fileIsAged(file, Instant.now())) {
            return true;
        }
        if (this.discardCallback != null) {
            this.discardCallback.accept(file);
        }
        return false;
    }

    private boolean fileIsAged(F file, Instant now) {
        return this.getLastModified(file).plus(this.age).isBefore(now);
    }

    @Override
    public boolean supportsSingleFileFiltering() {
        return true;
    }

    protected Duration getAgeDuration() {
        return this.age;
    }

    protected abstract Instant getLastModified(F var1);
}

