/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class OSDelegatingFileTailingMessageProducer
extends FileTailingMessageProducerSupport
implements SchedulingAwareRunnable {
    private volatile Process nativeTailProcess;
    private volatile String options = "-F -n 0";
    private volatile String command = "ADAPTER_NOT_INITIALIZED";
    private volatile boolean enableStatusReader = true;
    private volatile BufferedReader stdOutReader;

    public void setOptions(String options) {
        this.options = options == null ? "" : options;
    }

    public void setEnableStatusReader(boolean enableStatusReader) {
        this.enableStatusReader = enableStatusReader;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType() + " (native)";
    }

    public boolean isLongLived() {
        return true;
    }

    protected void onInit() {
        Assert.notNull((Object)this.getFile(), (String)"File cannot be null");
        super.onInit();
    }

    @Override
    protected void doStart() {
        super.doStart();
        this.destroyProcess();
        this.command = "tail " + this.options + " " + this.getFile().getAbsolutePath();
        this.getTaskExecutor().execute(this::runExec);
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.destroyProcess();
    }

    private void destroyProcess() {
        Process process = this.nativeTailProcess;
        if (process != null) {
            process.destroy();
            this.nativeTailProcess = null;
        }
    }

    private void runExec() {
        this.destroyProcess();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Starting tail process");
        }
        try {
            Process process = Runtime.getRuntime().exec(this.command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.nativeTailProcess = process;
            this.startProcessMonitor();
            if (this.enableStatusReader) {
                this.startStatusReader();
            }
            this.stdOutReader = reader;
            this.getTaskExecutor().execute((Runnable)((Object)this));
        }
        catch (IOException e) {
            throw new MessagingException("Failed to exec tail command: '" + this.command + "'", (Throwable)e);
        }
    }

    private void startProcessMonitor() {
        this.getTaskExecutor().execute(() -> {
            Process process = this.nativeTailProcess;
            if (process == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Process destroyed before starting process monitor");
                }
                return;
            }
            int result = Integer.MIN_VALUE;
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Monitoring process " + process));
                }
                result = process.waitFor();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("tail process terminated with value " + result));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error((Object)"Interrupted - stopping adapter", (Throwable)e);
                this.stop();
            }
            finally {
                this.destroyProcess();
            }
            if (this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Restarting tail process in " + this.getMissingFileDelay() + " milliseconds"));
                }
                this.getTaskScheduler().schedule(this::runExec, new Date(System.currentTimeMillis() + this.getMissingFileDelay()));
            }
        });
    }

    private void startStatusReader() {
        Process process = this.nativeTailProcess;
        if (process == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Process destroyed before starting stderr reader");
            }
            return;
        }
        this.getTaskExecutor().execute(() -> {
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Reading stderr");
            }
            try {
                String statusMessage;
                while ((statusMessage = errorReader.readLine()) != null) {
                    this.publish(statusMessage);
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)statusMessage);
                }
            }
            catch (IOException e1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Exception on tail error reader", (Throwable)e1);
                }
            }
            finally {
                block15: {
                    try {
                        errorReader.close();
                    }
                    catch (IOException e2) {
                        if (!this.logger.isDebugEnabled()) break block15;
                        this.logger.debug((Object)"Exception while closing stderr", (Throwable)e2);
                    }
                }
            }
        });
    }

    public void run() {
        try {
            String line;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Reading stdout");
            }
            while ((line = this.stdOutReader.readLine()) != null) {
                this.send(line);
            }
        }
        catch (IOException e) {
            block7: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Exception on tail reader", (Throwable)e);
                }
                try {
                    this.stdOutReader.close();
                }
                catch (IOException e1) {
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug((Object)"Exception while closing stdout", (Throwable)e);
                }
            }
            this.destroyProcess();
        }
    }
}

