/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.springframework.integration.file.transformer.AbstractFilePayloadTransformer;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class FileToStringTransformer
extends AbstractFilePayloadTransformer<String> {
    private volatile Charset charset = Charset.defaultCharset();

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("Charset '" + charset + "' is not supported."));
        this.charset = Charset.forName(charset);
    }

    @Override
    protected final String transformFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
        return FileCopyUtils.copyToString((Reader)reader);
    }
}

