/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.aop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.aop.AbstractMessageSourceAdvice;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.session.DelegatingSessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizingMessageSource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RotatingServerAdvice
extends AbstractMessageSourceAdvice {
    private final RotationPolicy rotationPolicy;

    public RotatingServerAdvice(DelegatingSessionFactory<?> factory, List<KeyDirectory> keyDirectories) {
        this(factory, keyDirectories, false);
    }

    public RotatingServerAdvice(DelegatingSessionFactory<?> factory, List<KeyDirectory> keyDirectories, boolean fair) {
        this(new StandardRotationPolicy(factory, keyDirectories, fair));
    }

    public RotatingServerAdvice(RotationPolicy rotationPolicy) {
        Assert.notNull((Object)rotationPolicy, (String)"'rotationPolicy' cannot be null");
        this.rotationPolicy = rotationPolicy;
    }

    public boolean beforeReceive(MessageSource<?> source) {
        this.rotationPolicy.beforeReceive(source);
        return true;
    }

    public Message<?> afterReceive(Message<?> result, MessageSource<?> source) {
        this.rotationPolicy.afterReceive(result != null, source);
        return result;
    }

    public static class KeyDirectory {
        private final Object key;
        private final String directory;

        public KeyDirectory(Object key, String directory) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            Assert.notNull((Object)directory, (String)"directory cannot be null");
            this.key = key;
            this.directory = directory;
        }

        public Object getKey() {
            return this.key;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String toString() {
            return "KeyDirectory [key=" + this.key.toString() + ", directory=" + this.directory + "]";
        }
    }

    public static class StandardRotationPolicy
    implements RotationPolicy {
        protected final Log logger = LogFactory.getLog(this.getClass());
        protected final DelegatingSessionFactory<?> factory;
        private final List<KeyDirectory> keyDirectories = new ArrayList<KeyDirectory>();
        private final boolean fair;
        private volatile Iterator<KeyDirectory> iterator;
        private volatile KeyDirectory current;
        private volatile boolean initialized;

        public StandardRotationPolicy(DelegatingSessionFactory<?> factory, List<KeyDirectory> keyDirectories, boolean fair) {
            Assert.notNull(factory, (String)"factory cannot be null");
            Assert.notNull(keyDirectories, (String)"keyDirectories cannot be null");
            Assert.isTrue((keyDirectories.size() > 0 ? 1 : 0) != 0, (String)"At least one KeyDirectory is required");
            this.factory = factory;
            this.keyDirectories.addAll(keyDirectories);
            this.fair = fair;
            this.iterator = this.keyDirectories.iterator();
        }

        protected Iterator<KeyDirectory> getIterator() {
            return this.iterator;
        }

        protected void setIterator(Iterator<KeyDirectory> iterator) {
            this.iterator = iterator;
        }

        protected boolean isInitialized() {
            return this.initialized;
        }

        protected void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        protected DelegatingSessionFactory<?> getFactory() {
            return this.factory;
        }

        protected List<KeyDirectory> getKeyDirectories() {
            return this.keyDirectories;
        }

        protected boolean isFair() {
            return this.fair;
        }

        protected KeyDirectory getCurrent() {
            return this.current;
        }

        @Override
        public void beforeReceive(MessageSource<?> source) {
            if (this.fair || !this.initialized) {
                this.configureSource(source);
                this.initialized = true;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Next poll is for " + this.current));
            }
            this.factory.setThreadKey(this.current.getKey());
        }

        @Override
        public void afterReceive(boolean messageReceived, MessageSource<?> source) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Poll produced " + (messageReceived ? "a" : "no") + " message"));
            }
            this.factory.clearThreadKey();
            if (!this.fair && !messageReceived) {
                this.configureSource(source);
            }
        }

        protected void configureSource(MessageSource<?> source) {
            Assert.isTrue((source instanceof AbstractInboundFileSynchronizingMessageSource || source instanceof AbstractRemoteFileStreamingMessageSource ? 1 : 0) != 0, (String)"source must be an AbstractInboundFileSynchronizingMessageSource or a AbstractRemoteFileStreamingMessageSource");
            if (!this.iterator.hasNext()) {
                this.iterator = this.keyDirectories.iterator();
            }
            this.current = this.iterator.next();
            if (source instanceof AbstractRemoteFileStreamingMessageSource) {
                ((AbstractRemoteFileStreamingMessageSource)source).setRemoteDirectory(this.current.getDirectory());
            } else {
                ((AbstractInboundFileSynchronizingMessageSource)source).getSynchronizer().setRemoteDirectory(this.current.getDirectory());
            }
        }
    }

    public static interface RotationPolicy {
        public void beforeReceive(MessageSource<?> var1);

        public void afterReceive(boolean var1, MessageSource<?> var2);
    }
}

