/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.locking.AbstractFileLockerFilter;

public class FileReadingMessageSourceFactoryBean
implements FactoryBean<FileReadingMessageSource>,
BeanFactoryAware {
    private static Log logger = LogFactory.getLog(FileReadingMessageSourceFactoryBean.class);
    private volatile FileReadingMessageSource source;
    private volatile File directory;
    private volatile FileListFilter<File> filter;
    private volatile AbstractFileLockerFilter locker;
    private volatile Comparator<File> comparator;
    private volatile DirectoryScanner scanner;
    private boolean useWatchService;
    private FileReadingMessageSource.WatchEventType[] watchEvents;
    private volatile Boolean scanEachPoll;
    private volatile Boolean autoCreateDirectory;
    private volatile Integer queueSize;
    private volatile BeanFactory beanFactory;
    private final Object initializationMonitor = new Object();

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    public void setScanner(DirectoryScanner scanner) {
        this.scanner = scanner;
    }

    public void setUseWatchService(boolean useWatchService) {
        this.useWatchService = useWatchService;
    }

    public void setWatchEvents(FileReadingMessageSource.WatchEventType ... watchEvents) {
        this.watchEvents = watchEvents;
    }

    public void setFilter(FileListFilter<File> filter) {
        if (filter instanceof AbstractFileLockerFilter && this.locker == null) {
            this.setLocker((AbstractFileLockerFilter)filter);
        }
        this.filter = filter;
    }

    public void setScanEachPoll(Boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public void setLocker(AbstractFileLockerFilter locker) {
        this.locker = locker;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public FileReadingMessageSource getObject() throws Exception {
        if (this.source == null) {
            this.initSource();
        }
        return this.source;
    }

    public Class<?> getObjectType() {
        return FileReadingMessageSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSource() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            boolean queueSizeSet;
            if (this.source != null) {
                return;
            }
            boolean comparatorSet = this.comparator != null;
            boolean bl = queueSizeSet = this.queueSize != null;
            if (comparatorSet) {
                if (queueSizeSet) {
                    logger.warn((Object)"'comparator' and 'queueSize' are mutually exclusive. Ignoring 'queueSize'");
                }
                this.source = new FileReadingMessageSource(this.comparator);
            } else {
                this.source = queueSizeSet ? new FileReadingMessageSource(this.queueSize) : new FileReadingMessageSource();
            }
            this.source.setDirectory(this.directory);
            if (this.scanner != null) {
                this.source.setScanner(this.scanner);
            } else {
                this.source.setUseWatchService(this.useWatchService);
                if (this.watchEvents != null) {
                    this.source.setWatchEvents(this.watchEvents);
                }
            }
            if (this.filter != null) {
                if (this.locker == null) {
                    this.source.setFilter(this.filter);
                } else {
                    CompositeFileListFilter<File> compositeFileListFilter = new CompositeFileListFilter<File>();
                    compositeFileListFilter.addFilter(this.filter);
                    compositeFileListFilter.addFilter(this.locker);
                    this.source.setFilter(compositeFileListFilter);
                    this.source.setLocker(this.locker);
                }
            } else if (this.locker != null) {
                CompositeFileListFilter<File> compositeFileListFilter = new CompositeFileListFilter<File>();
                compositeFileListFilter.addFilter((FileListFilter<File>)new FileListFilterFactoryBean().getObject());
                compositeFileListFilter.addFilter(this.locker);
                this.source.setFilter(compositeFileListFilter);
                this.source.setLocker(this.locker);
            }
            if (this.scanEachPoll != null) {
                this.source.setScanEachPoll(this.scanEachPoll);
            }
            if (this.autoCreateDirectory != null) {
                this.source.setAutoCreateDirectory(this.autoCreateDirectory);
            }
            if (this.beanFactory != null) {
                this.source.setBeanFactory(this.beanFactory);
            }
            this.source.afterPropertiesSet();
        }
    }
}

