/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.event.inbound;

import java.util.HashSet;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.integration.endpoint.ExpressionMessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ApplicationEventListeningMessageProducer
extends ExpressionMessageProducerSupport
implements GenericApplicationListener {
    private volatile Set<ResolvableType> eventTypes;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private volatile long stoppedAt;

    public ApplicationEventListeningMessageProducer() {
        this.setPhase(1073740823);
    }

    public final void setEventTypes(Class<?> ... eventTypes) {
        Assert.notNull(eventTypes, (String)"'eventTypes' must not be null");
        HashSet<ResolvableType> eventSet = new HashSet<ResolvableType>(eventTypes.length);
        for (Class<?> eventType : eventTypes) {
            if (eventType == null) continue;
            eventSet.add(ResolvableType.forClass(eventType));
        }
        Set<Object> set = this.eventTypes = eventSet.size() > 0 ? eventSet : null;
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.addApplicationListener((ApplicationListener)this);
        }
    }

    public String getComponentType() {
        return "event:inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBeanFactory().getBean("applicationEventMulticaster", ApplicationEventMulticaster.class);
        Assert.notNull((Object)this.applicationEventMulticaster, (String)"To use ApplicationListeners the 'applicationEventMulticaster' bean must be supplied within ApplicationContext.");
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isActive() || (event instanceof ContextStoppedEvent || event instanceof ContextClosedEvent) && this.stoppedRecently()) {
            Object source = event.getSource();
            if (source instanceof Message) {
                this.sendMessage((Message)source);
            } else {
                Object result = this.extractObjectToSend(event);
                Message message = result instanceof Message ? (Message)result : this.getMessageBuilderFactory().withPayload(result).build();
                this.sendMessage(message);
            }
        }
    }

    private Object extractObjectToSend(Object root) {
        if (root instanceof PayloadApplicationEvent) {
            return ((PayloadApplicationEvent)root).getPayload();
        }
        return this.evaluatePayloadExpression(root);
    }

    private boolean stoppedRecently() {
        return this.stoppedAt > System.currentTimeMillis() - 5000L;
    }

    public boolean supportsEventType(ResolvableType eventType) {
        if (this.eventTypes == null) {
            return true;
        }
        for (ResolvableType type : this.eventTypes) {
            if (!type.isAssignableFrom(eventType)) continue;
            return true;
        }
        if (eventType.getRawClass() != null && PayloadApplicationEvent.class.isAssignableFrom(eventType.getRawClass())) {
            if (eventType.hasUnresolvableGenerics()) {
                return true;
            }
            ResolvableType payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]);
            for (ResolvableType type : this.eventTypes) {
                if (!type.isAssignableFrom(payloadType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void doStop() {
        this.stoppedAt = System.currentTimeMillis();
        super.doStop();
    }
}

