/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.debezium.support;

import io.debezium.engine.Header;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.HeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;

public class DefaultDebeziumHeaderMapper
implements HeaderMapper<List<Header<Object>>> {
    private String[] headerNamesToMap = new String[]{"*"};

    public void setHeaderNamesToMap(String ... headerNames) {
        Assert.notNull((Object)headerNames, (String)"'HeaderNames' must not be null.");
        Assert.noNullElements((Object[])headerNames, (String)"'HeaderNames' must not contains null elements.");
        Object[] copy = Arrays.copyOf(headerNames, headerNames.length);
        Arrays.sort(copy);
        this.headerNamesToMap = copy;
    }

    public MessageHeaders toHeaders(List<Header<Object>> debeziumHeaders) {
        HashMap<String, Object> messageHeaders = null;
        if (!CollectionUtils.isEmpty(debeziumHeaders)) {
            messageHeaders = new HashMap<String, Object>();
            for (Header<Object> header : debeziumHeaders) {
                String headerName = header.getKey();
                if (!DefaultDebeziumHeaderMapper.shouldMapHeader(headerName, this.headerNamesToMap)) continue;
                Object headerValue = header.getValue();
                messageHeaders.put(headerName, headerValue);
            }
        }
        return new MessageHeaders(messageHeaders);
    }

    public void fromHeaders(MessageHeaders headers, List<Header<Object>> target) {
        throw new UnsupportedOperationException("The 'fromHeaders' is not supported!");
    }

    private static boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns.length > 0) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) continue;
                return true;
            }
        }
        return false;
    }
}

