/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.cassandra.config.xml;

import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class CassandraParserUtils {
    public static void processOutboundTypeAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinition statementExpressionDef;
        String cassandraTemplate = element.getAttribute("cassandra-template");
        String mode = element.getAttribute("mode");
        String ingestQuery = element.getAttribute("ingest-query");
        String query = element.getAttribute("query");
        if (!StringUtils.hasText((String)cassandraTemplate)) {
            parserContext.getReaderContext().error("cassandra-template is required", (Object)element);
        }
        builder.addConstructorArgReference(cassandraTemplate);
        if (StringUtils.hasText((String)mode)) {
            builder.addConstructorArgValue((Object)mode);
        }
        if ((statementExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"statement-expression", (Element)element)) != null) {
            builder.addPropertyValue("statementExpression", (Object)statementExpressionDef);
        }
        if (!CassandraParserUtils.areMutuallyExclusive(query, statementExpressionDef, ingestQuery)) {
            parserContext.getReaderContext().error("'query', 'ingest-query', 'statement-expression' are mutually exclusive", (Object)element);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"write-options");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"ingest-query");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"query");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"async");
        List parameterExpressions = DomUtils.getChildElementsByTagName((Element)element, (String)"parameter-expression");
        if (!CollectionUtils.isEmpty((Collection)parameterExpressions)) {
            ManagedMap parameterExpressionsMap = new ManagedMap();
            for (Element parameterExpressionElement : parameterExpressions) {
                String name = parameterExpressionElement.getAttribute("name");
                BeanDefinition expression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"expression", (Element)parameterExpressionElement);
                if (expression == null) continue;
                parameterExpressionsMap.put((Object)name, (Object)expression);
            }
            builder.addPropertyValue("parameterExpressions", (Object)parameterExpressionsMap);
        }
    }

    private static boolean areMutuallyExclusive(String query, @Nullable BeanDefinition statementExpressionDef, String ingestQuery) {
        return !StringUtils.hasText((String)query) && statementExpressionDef == null && !StringUtils.hasText((String)ingestQuery) || (!StringUtils.hasText((String)query) || statementExpressionDef == null || !StringUtils.hasText((String)ingestQuery)) && StringUtils.hasText((String)query) ^ statementExpressionDef != null ^ StringUtils.hasText((String)ingestQuery);
    }

    private CassandraParserUtils() {
    }
}

