/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.camel.outbound;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.camel.support.CamelHeaderMapper;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CamelMessageHandler
extends AbstractReplyProducingMessageHandler {
    private ProducerTemplate producerTemplate;
    private Expression exchangePatternExpression = new ValueExpression((Object)ExchangePattern.InOnly);
    private @Nullable Expression endpointUriExpression;
    private @Nullable LambdaRouteBuilder route;
    private HeaderMapper<Message> headerMapper = new CamelHeaderMapper();
    private @Nullable Expression exchangePropertiesExpression;
    private StandardEvaluationContext evaluationContext;

    public CamelMessageHandler() {
    }

    public CamelMessageHandler(ProducerTemplate producerTemplate) {
        Assert.notNull((Object)producerTemplate, (String)"'producerTemplate' must not be null");
        this.producerTemplate = producerTemplate;
    }

    public void setEndpointUri(String endpointUri) {
        Assert.hasText((String)endpointUri, (String)"'endpointUri' must not be empty");
        this.setEndpointUriExpression((Expression)new LiteralExpression(endpointUri));
    }

    public void setEndpointUriExpression(Expression endpointUriExpression) {
        Assert.notNull((Object)endpointUriExpression, (String)"'endpointUriExpression' must not be null");
        this.endpointUriExpression = endpointUriExpression;
    }

    public void setRoute(LambdaRouteBuilder route) {
        Assert.notNull((Object)route, (String)"'route' must not be null");
        this.route = route;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        Assert.notNull((Object)exchangePattern, (String)"'exchangePattern' must not be null");
        this.setExchangePatternExpression((Expression)new ValueExpression((Object)exchangePattern));
    }

    public void setExchangePatternExpression(Expression exchangePatternExpression) {
        Assert.notNull((Object)exchangePatternExpression, (String)"'exchangePatternExpression' must not be null");
        this.exchangePatternExpression = exchangePatternExpression;
    }

    public void setHeaderMapper(HeaderMapper<Message> headerMapper) {
        Assert.notNull(headerMapper, (String)"'headerMapper' must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExchangeProperties(Map<String, Object> exchangeProperties) {
        Assert.notNull(exchangeProperties, (String)"'exchangeProperties' must not be null");
        this.setExchangePropertiesExpression((Expression)new ValueExpression(exchangeProperties));
    }

    public void setExchangePropertiesExpression(Expression exchangePropertiesExpression) {
        this.exchangePropertiesExpression = exchangePropertiesExpression;
    }

    protected final void doInit() {
        LambdaRouteBuilder lambdaRouteBuilder;
        Assert.state((this.endpointUriExpression == null || this.route == null ? 1 : 0) != 0, (String)"The 'endpointUri' option is mutually exclusive with 'route'");
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.producerTemplate == null) {
            this.producerTemplate = ((CamelContext)beanFactory.getBean(CamelContext.class)).createProducerTemplate();
        }
        if ((lambdaRouteBuilder = this.route) != null) {
            CamelContext camelContext = this.producerTemplate.getCamelContext();
            RouteBuilder routeBuilder = new RouteBuilder(this, camelContext){
                final /* synthetic */ CamelMessageHandler this$0;
                {
                    this.this$0 = this$0;
                    super(context);
                }

                public void configure() throws Exception {
                    lambdaRouteBuilder.accept((Object)this);
                }
            };
            try {
                camelContext.addRoutes((RoutesBuilder)routeBuilder);
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Cannot load Camel route", (Throwable)ex);
            }
            RouteDefinition routeDefinition = (RouteDefinition)routeBuilder.getRouteCollection().getRoutes().get(0);
            this.endpointUriExpression = new LiteralExpression(routeDefinition.getInput().getEndpointUri());
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory);
    }

    protected @Nullable Object handleRequestMessage(org.springframework.messaging.Message<?> requestMessage) {
        ExchangePattern exchangePattern = (ExchangePattern)this.exchangePatternExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, ExchangePattern.class);
        Assert.notNull((Object)exchangePattern, (String)"'exchangePatternExpression' must not evaluate to null");
        Endpoint endpoint = this.resolveEndpoint(requestMessage);
        Exchange exchange = this.prepareInExchange(endpoint, exchangePattern, requestMessage);
        if (this.isAsync()) {
            CompletableFuture result = this.producerTemplate.asyncSend(endpoint, exchange);
            return result.thenApply(resultExchange -> this.buildReply(exchangePattern, (Exchange)resultExchange));
        }
        Exchange result = this.producerTemplate.send(endpoint, exchange);
        return this.buildReply(exchangePattern, result);
    }

    private Endpoint resolveEndpoint(org.springframework.messaging.Message<?> requestMessage) {
        String endpointUri;
        String string = endpointUri = this.endpointUriExpression != null ? (String)this.endpointUriExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class) : null;
        if (StringUtils.hasText(endpointUri)) {
            return this.producerTemplate.getCamelContext().getEndpoint(endpointUri);
        }
        return this.producerTemplate.getDefaultEndpoint();
    }

    private Exchange prepareInExchange(Endpoint endpoint, ExchangePattern exchangePattern, org.springframework.messaging.Message<?> requestMessage) {
        Map exchangeProperties;
        Exchange exchange = endpoint.createExchange(exchangePattern);
        Map map = exchangeProperties = this.exchangePropertiesExpression != null ? (Map)this.exchangePropertiesExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, Map.class) : null;
        if (exchangeProperties != null) {
            for (Map.Entry property : exchangeProperties.entrySet()) {
                exchange.setProperty((String)property.getKey(), property.getValue());
            }
        }
        Message in = exchange.getIn();
        this.headerMapper.fromHeaders(requestMessage.getHeaders(), (Object)in);
        in.setBody(requestMessage.getPayload());
        return exchange;
    }

    private @Nullable AbstractIntegrationMessageBuilder<?> buildReply(ExchangePattern exchangePattern, Exchange result) {
        if (result.isFailed()) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)result, (Throwable)result.getException());
        }
        if (exchangePattern.isOutCapable()) {
            Message out = result.getMessage();
            return this.getMessageBuilderFactory().withPayload(out.getBody()).copyHeaders(this.headerMapper.toHeaders((Object)out));
        }
        return null;
    }
}

