/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.camel.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class CamelHeaderMapper
implements HeaderMapper<Message> {
    private static final LogAccessor LOGGER = new LogAccessor(CamelHeaderMapper.class);
    private String[] inboundHeaderNames = new String[]{"*"};
    private String[] outboundHeaderNames = new String[]{"*"};

    public void setInboundHeaderNames(String ... inboundHeaderNames) {
        Assert.notNull((Object)inboundHeaderNames, (String)"'inboundHeaderNames' must not be null");
        Object[] copy = Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length);
        Arrays.sort(copy);
        this.inboundHeaderNames = copy;
    }

    public void setOutboundHeaderNames(String ... outboundHeaderNames) {
        Assert.notNull((Object)outboundHeaderNames, (String)"'outboundHeaderNames' must not be null");
        Object[] copy = Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length);
        Arrays.sort(copy);
        this.outboundHeaderNames = copy;
    }

    public void fromHeaders(MessageHeaders headers, Message target) {
        for (Map.Entry entry : headers.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (!CamelHeaderMapper.shouldMapHeader(name, this.outboundHeaderNames) || (value = entry.getValue()) == null) continue;
            target.setHeader(name, value);
        }
    }

    public Map<String, Object> toHeaders(Message source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (Map.Entry entry : source.getHeaders().entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (!CamelHeaderMapper.shouldMapHeader(name, this.inboundHeaderNames) || (value = entry.getValue()) == null) continue;
            headers.put(name, value);
        }
        return headers;
    }

    private static boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns.length > 0) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) continue;
                LOGGER.debug((CharSequence)LogMessage.format((String)"headerName=[{0}] WILL be mapped, matched pattern={1}", (Object)headerName, (Object)pattern));
                return true;
            }
        }
        LOGGER.debug((CharSequence)LogMessage.format((String)"headerName=[{0}] WILL NOT be mapped", (Object)headerName));
        return false;
    }
}

