/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import java.nio.ByteBuffer;
import org.springframework.integration.aws.support.AbstractMessageAttributesHeaderMapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public class SqsHeaderMapper
extends AbstractMessageAttributesHeaderMapper<MessageAttributeValue> {
    @Override
    protected MessageAttributeValue buildMessageAttribute(String dataType, Object value) {
        MessageAttributeValue.Builder messageAttributeValue = MessageAttributeValue.builder().dataType(dataType);
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)value;
            messageAttributeValue.binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer));
        } else {
            messageAttributeValue.stringValue(value.toString());
        }
        return (MessageAttributeValue)messageAttributeValue.build();
    }
}

