/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsAffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptions;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptionsFactory;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class HalFormsPropertyFactory {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final HalFormsConfiguration configuration;
    private final MessageResolver resolver;

    public HalFormsPropertyFactory(HalFormsConfiguration configuration, MessageResolver resolver) {
        Assert.notNull((Object)configuration, (String)"HalFormsConfiguration must not be null!");
        Assert.notNull((Object)resolver, (String)"MessageResolver must not be null!");
        this.configuration = configuration;
        this.resolver = resolver;
    }

    public List<HalFormsProperty> createProperties(HalFormsAffordanceModel model) {
        Assert.notNull((Object)model, (String)"HalFormsModel must not be null!");
        if (!ENTITY_ALTERING_METHODS.contains(model.getHttpMethod())) {
            return Collections.emptyList();
        }
        HalFormsOptionsFactory optionsFactory = this.configuration.getOptionsFactory();
        return model.createProperties((AffordanceModel.InputPayloadMetadata payload, AffordanceModel.PropertyMetadata metadata) -> {
            String inputType = metadata.getInputType();
            HalFormsOptions options = optionsFactory.getOptions((AffordanceModel.PayloadMetadata)payload, (AffordanceModel.PropertyMetadata)metadata);
            HalFormsProperty property = new HalFormsProperty().withName(metadata.getName()).withRequired(metadata.isRequired()).withReadOnly(metadata.isReadOnly()).withMin(metadata.getMin()).withMax(metadata.getMax()).withMinLength(metadata.getMinLength()).withMaxLength(metadata.getMaxLength()).withRegex(this.lookupRegex((AffordanceModel.PropertyMetadata)metadata)).withType(inputType).withValue(options != null ? options.getSelectedValue() : null).withOptions(options);
            Function<String, I18nedPropertyMetadata> factory = I18nedPropertyMetadata.factory(payload, property);
            return Optional.of(property).map(it -> this.i18n((HalFormsProperty)it, (MessageSourceResolvable)factory.apply("_placeholder"), it::withPlaceholder)).map(it -> this.i18n((HalFormsProperty)it, (MessageSourceResolvable)factory.apply("_prompt"), it::withPrompt)).map(it -> model.hasHttpMethod(HttpMethod.PATCH) ? it.withRequired(false) : it).orElse(property);
        });
    }

    private Optional<String> lookupRegex(AffordanceModel.PropertyMetadata metadata) {
        Optional<String> pattern = metadata.getPattern();
        if (pattern.isPresent()) {
            return pattern;
        }
        return this.configuration.getTypePatternFor(metadata.getType());
    }

    private HalFormsProperty i18n(HalFormsProperty property, MessageSourceResolvable metadata, Function<String, HalFormsProperty> application) {
        String resolved = this.resolver.resolve(metadata);
        return !StringUtils.hasText((String)resolved) ? property : application.apply(resolved);
    }

    private static class I18nedPropertyMetadata
    implements MessageSourceResolvable {
        private final String template;
        private final AffordanceModel.InputPayloadMetadata metadata;
        private final HalFormsProperty property;

        private I18nedPropertyMetadata(String template, AffordanceModel.InputPayloadMetadata metadata, HalFormsProperty property) {
            this.template = template;
            this.metadata = metadata;
            this.property = property;
        }

        public static Function<String, I18nedPropertyMetadata> factory(AffordanceModel.InputPayloadMetadata metadata, HalFormsProperty property) {
            return suffix -> new I18nedPropertyMetadata("%s.".concat((String)suffix), metadata, property);
        }

        public @Nullable String getDefaultMessage() {
            return "";
        }

        public String @NonNull [] getCodes() {
            String globalCode = String.format(this.template, this.property.getName());
            ArrayList<String> codes = new ArrayList<String>();
            this.metadata.getI18nCodes().stream().map(it -> String.format("%s.%s", it, globalCode)).forEach(codes::add);
            codes.add(globalCode);
            return codes.toArray(new String[0]);
        }
    }
}

