/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0002B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000f\u001a\u00020\u0010\"\b\b\u0002\u0010\u0003*\u00020\u00022\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00030\u0012\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004J\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0018H\u0086\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/springframework/hateoas/server/mvc/WebMvcLinkBuilderDsl;", "C", "", "R", "Lorg/springframework/hateoas/RepresentationModel;", "controller", "Ljava/lang/Class;", "resource", "<init>", "(Ljava/lang/Class;Lorg/springframework/hateoas/RepresentationModel;)V", "getController", "()Ljava/lang/Class;", "getResource", "()Lorg/springframework/hateoas/RepresentationModel;", "Lorg/springframework/hateoas/RepresentationModel;", "linkTo", "Lorg/springframework/hateoas/server/mvc/WebMvcLinkBuilder;", "func", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withRel", "Lorg/springframework/hateoas/Link;", "rel", "", "Lorg/springframework/hateoas/LinkRelation;", "spring-hateoas"})
public class WebMvcLinkBuilderDsl<C, R extends RepresentationModel<R>> {
    @NotNull
    private final Class<C> controller;
    @NotNull
    private final R resource;

    public WebMvcLinkBuilderDsl(@NotNull Class<C> controller, @NotNull R resource) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        this.controller = controller;
        this.resource = resource;
    }

    @NotNull
    public final Class<C> getController() {
        return this.controller;
    }

    @NotNull
    public final R getResource() {
        return this.resource;
    }

    @NotNull
    public final <R> WebMvcLinkBuilder linkTo(@NotNull Function1<? super C, ? extends R> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        C c = WebMvcLinkBuilder.methodOn(this.controller, new Object[0]);
        Intrinsics.checkNotNullExpressionValue(c, (String)"methodOn(...)");
        WebMvcLinkBuilder webMvcLinkBuilder = WebMvcLinkBuilder.linkTo(func.invoke(c));
        Intrinsics.checkNotNullExpressionValue((Object)webMvcLinkBuilder, (String)"linkTo(...)");
        return webMvcLinkBuilder;
    }

    @NotNull
    public final Link withRel(@NotNull WebMvcLinkBuilder $this$withRel, @NotNull String rel) {
        Intrinsics.checkNotNullParameter((Object)$this$withRel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rel, (String)"rel");
        LinkRelation linkRelation = LinkRelation.of(rel);
        Intrinsics.checkNotNullExpressionValue((Object)linkRelation, (String)"of(...)");
        return this.withRel($this$withRel, linkRelation);
    }

    @NotNull
    public final Link withRel(@NotNull WebMvcLinkBuilder $this$withRel, @NotNull LinkRelation rel) {
        Intrinsics.checkNotNullParameter((Object)$this$withRel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rel, (String)"rel");
        Link link = $this$withRel.withRel(rel);
        Intrinsics.checkNotNullExpressionValue((Object)link, (String)"withRel(...)");
        Link link2 = link;
        ((RepresentationModel)this.resource).add(link2);
        return link2;
    }
}

