/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.server.mvc.TypeConstrainedJacksonJsonHttpMessageConverter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;
import tools.jackson.databind.json.JsonMapper;

public class HalFormsHttpMessageConverter
extends TypeConstrainedJacksonJsonHttpMessageConverter {
    private final HalFormsTemplateBuilder builder;

    public HalFormsHttpMessageConverter(BeanFactory factory, JsonMapper mapper) {
        super(RepresentationModel.class, List.of(MediaTypes.HAL_FORMS_JSON), mapper);
        Assert.notNull((Object)factory, (String)"BeanFactory must not be null!");
        Assert.notNull((Object)mapper, (String)"Mapper must not be null!");
        this.builder = (HalFormsTemplateBuilder)factory.getBean(HalFormsTemplateBuilder.class);
    }

    protected void writeInternal(Object object, ResolvableType type, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        if (!(object instanceof RepresentationModel)) {
            super.writeInternal(object, type, outputMessage, hints);
            return;
        }
        RepresentationModel model = (RepresentationModel)object;
        Map<String, HalFormsTemplate> result = this.builder.findTemplates(model);
        if (result.isEmpty()) {
            HttpHeaders headers = outputMessage.getHeaders();
            headers.setContentType(MediaTypes.HAL_JSON);
        }
        super.writeInternal(object, type, outputMessage, hints);
    }
}

