/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CollectionModel<T>
extends RepresentationModel<CollectionModel<T>>
implements Iterable<T>,
ResolvableTypeProvider {
    private final Collection<T> content;
    private final @Nullable ResolvableType fallbackType;
    private @Nullable ResolvableType fullType;

    protected CollectionModel() {
        this((Iterable<T>)Collections.emptyList());
    }

    protected CollectionModel(Iterable<T> content) {
        this(content, Links.NONE, null);
    }

    protected CollectionModel(Iterable<T> content, Iterable<Link> links, @Nullable ResolvableType fallbackType) {
        Assert.notNull(content, (String)"Content must not be null!");
        Assert.notNull(links, (String)"Links must not be null!");
        this.content = new ArrayList<T>();
        for (T element : content) {
            this.content.add(element);
        }
        this.add(links);
        this.fallbackType = fallbackType;
    }

    public static <T> CollectionModel<T> empty() {
        return CollectionModel.of(Collections.emptyList());
    }

    public static <T> CollectionModel<T> empty(Class<T> elementType, Class<?> ... generics) {
        return CollectionModel.empty(ResolvableType.forClassWithGenerics(elementType, (Class[])generics));
    }

    public static <T> CollectionModel<T> empty(ParameterizedTypeReference<T> type) {
        return CollectionModel.empty(ResolvableType.forType((Type)type.getType()));
    }

    public static <T> CollectionModel<T> empty(ResolvableType elementType) {
        return new CollectionModel(Collections.emptyList(), Collections.emptyList(), elementType);
    }

    public static <T> CollectionModel<T> empty(Link ... links) {
        return CollectionModel.of(Collections.emptyList(), links);
    }

    public static <T> CollectionModel<T> empty(Iterable<Link> links) {
        return CollectionModel.of(Collections.emptyList(), links);
    }

    public static <T> CollectionModel<T> of(Iterable<T> content) {
        return CollectionModel.of(content, Collections.emptyList());
    }

    public static <T> CollectionModel<T> of(Iterable<T> content, Link ... links) {
        return CollectionModel.of(content, Arrays.asList(links));
    }

    public static <T> CollectionModel<T> of(Iterable<T> content, Iterable<Link> links) {
        return new CollectionModel<T>(content, links, null);
    }

    public static <T extends EntityModel<S>, S> CollectionModel<T> wrap(Iterable<S> content) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<EntityModel<S>> resources = new ArrayList<EntityModel<S>>();
        for (S element : content) {
            resources.add(EntityModel.of(element));
        }
        return CollectionModel.of(resources);
    }

    @JsonProperty(value="content")
    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }

    public CollectionModel<T> withFallbackType(Class<? super T> type, Class<?> ... generics) {
        Assert.notNull(type, (String)"Fallback type must not be null!");
        Assert.notNull(generics, (String)"Generics must not be null!");
        return this.withFallbackType(ResolvableType.forClassWithGenerics(type, (Class[])generics));
    }

    public CollectionModel<T> withFallbackType(ParameterizedTypeReference<?> type) {
        Assert.notNull(type, (String)"Fallback type must not be null!");
        return this.withFallbackType(ResolvableType.forType(type));
    }

    public CollectionModel<T> withFallbackType(ResolvableType type) {
        Assert.notNull((Object)type, (String)"Fallback type must not be null!");
        return new CollectionModel<T>(this.content, this.getLinks(), type);
    }

    @JsonIgnore
    public @NonNull ResolvableType getResolvableType() {
        if (this.fullType == null) {
            ResolvableType elementType = CollectionModel.deriveElementType(this.content, this.fallbackType);
            Class<?> type = this.getClass();
            this.fullType = elementType == null || type.getTypeParameters().length == 0 ? ResolvableType.forClass(type) : ResolvableType.forClassWithGenerics(type, (ResolvableType[])new ResolvableType[]{elementType});
        }
        return this.fullType;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public String toString() {
        return String.format("CollectionModel { content: %s, fallbackType: %s, %s }", this.getContent(), this.fallbackType, super.toString());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        CollectionModel that = (CollectionModel)obj;
        return Objects.equals(this.content, that.content) && Objects.equals(this.fallbackType, that.fallbackType) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.content, this.fallbackType);
    }

    private static @Nullable ResolvableType deriveElementType(Collection<?> elements, @Nullable ResolvableType fallbackType) {
        if (elements.isEmpty()) {
            return fallbackType;
        }
        return elements.stream().filter(it -> it != null).map(Object::getClass).reduce(ClassUtils::determineCommonAncestor).map(ResolvableType::forClass).orElse(fallbackType);
    }
}

