/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.MediaTypes;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class HalConfiguration {
    private static final PathMatcher MATCHER = new AntPathMatcher();
    private final RenderSingleLinks renderSingleLinks;
    private final Map<String, RenderSingleLinks> singleLinksPerPattern;
    private final Consumer<ObjectMapper> objectMapperCustomizer;
    private final List<MediaType> mediaTypes;
    private final boolean applyPropertyNamingStrategy;
    private final boolean enforceEmbeddedCollections;

    public HalConfiguration() {
        this(RenderSingleLinks.AS_SINGLE, new LinkedHashMap<String, RenderSingleLinks>(), true, true, __ -> {}, List.of(MediaTypes.HAL_JSON, MediaTypes.VND_HAL_JSON));
    }

    private HalConfiguration(RenderSingleLinks renderSingleLinks, Map<String, RenderSingleLinks> singleLinksPerPattern, boolean applyPropertyNamingStrategy, boolean enforceEmbeddedCollections, Consumer<ObjectMapper> objectMapperCustomizer, List<MediaType> mediaTypes) {
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        Assert.notNull(singleLinksPerPattern, (String)"Single links per pattern map must not be null!");
        Assert.notNull(objectMapperCustomizer, (String)"ObjectMapper customizer must not be null!");
        Assert.notNull(mediaTypes, (String)"MediaTypes must not be null!");
        this.renderSingleLinks = renderSingleLinks;
        this.singleLinksPerPattern = singleLinksPerPattern;
        this.applyPropertyNamingStrategy = applyPropertyNamingStrategy;
        this.enforceEmbeddedCollections = enforceEmbeddedCollections;
        this.objectMapperCustomizer = objectMapperCustomizer;
        this.mediaTypes = mediaTypes;
    }

    public HalConfiguration withRenderSingleLinksFor(LinkRelation relation, RenderSingleLinks renderSingleLinks) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        return this.withRenderSingleLinksFor(relation.value(), renderSingleLinks);
    }

    public HalConfiguration withRenderSingleLinksFor(String pattern, RenderSingleLinks renderSingleLinks) {
        Assert.hasText((String)pattern, (String)"Pattern must not be null or empty!");
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        LinkedHashMap<String, RenderSingleLinks> map = new LinkedHashMap<String, RenderSingleLinks>(this.singleLinksPerPattern);
        map.put(pattern, renderSingleLinks);
        return this.withSingleLinksPerPattern(map);
    }

    RenderSingleLinks getSingleLinkRenderModeFor(LinkRelation relation) {
        return this.singleLinksPerPattern.entrySet().stream().filter(entry -> MATCHER.match((String)entry.getKey(), relation.value())).map(Map.Entry::getValue).findFirst().orElse(this.renderSingleLinks);
    }

    public HalConfiguration withRenderSingleLinks(RenderSingleLinks renderSingleLinks) {
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        return this.renderSingleLinks == renderSingleLinks ? this : new HalConfiguration(renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections, this.objectMapperCustomizer, this.mediaTypes);
    }

    private HalConfiguration withSingleLinksPerPattern(Map<String, RenderSingleLinks> singleLinksPerPattern) {
        Assert.notNull(singleLinksPerPattern, (String)"Single links per pattern map must not be null!");
        return this.singleLinksPerPattern == singleLinksPerPattern ? this : new HalConfiguration(this.renderSingleLinks, singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections, this.objectMapperCustomizer, this.mediaTypes);
    }

    public HalConfiguration withApplyPropertyNamingStrategy(boolean applyPropertyNamingStrategy) {
        return this.applyPropertyNamingStrategy == applyPropertyNamingStrategy ? this : new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, applyPropertyNamingStrategy, this.enforceEmbeddedCollections, this.objectMapperCustomizer, this.mediaTypes);
    }

    public HalConfiguration withEnforceEmbeddedCollections(boolean enforceEmbeddedCollections) {
        return this.enforceEmbeddedCollections == enforceEmbeddedCollections ? this : new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, enforceEmbeddedCollections, this.objectMapperCustomizer, this.mediaTypes);
    }

    public HalConfiguration withObjectMapperCustomizer(Consumer<ObjectMapper> objectMapperCustomizer) {
        return this.objectMapperCustomizer == objectMapperCustomizer ? this : new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections, objectMapperCustomizer, this.mediaTypes);
    }

    public HalConfiguration withMediaType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"MediaType must not be null!");
        if (this.mediaTypes.contains(mediaType)) {
            return this;
        }
        ArrayList<MediaType> newMediaTypes = new ArrayList<MediaType>(this.mediaTypes);
        newMediaTypes.add(this.mediaTypes.size() - 1, mediaType);
        return new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections, this.objectMapperCustomizer, newMediaTypes);
    }

    public RenderSingleLinks getRenderSingleLinks() {
        return this.renderSingleLinks;
    }

    public boolean isApplyPropertyNamingStrategy() {
        return this.applyPropertyNamingStrategy;
    }

    public boolean isEnforceEmbeddedCollections() {
        return this.enforceEmbeddedCollections;
    }

    public HalConfiguration customize(ObjectMapper mapper) {
        this.objectMapperCustomizer.accept(mapper);
        return this;
    }

    List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public static enum RenderSingleLinks {
        AS_SINGLE,
        AS_ARRAY;

    }
}

