/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.util.Assert;

class WebConverters {
    private final List<HttpMessageConverter<?>> converters;

    private WebConverters(ObjectMapper mapper, List<HypermediaMappingInformation> mappingInformation) {
        this.converters = mappingInformation.stream().map(it -> WebConverters.createMessageConverter(it, it.configureObjectMapper(mapper.copy()))).collect(Collectors.toList());
    }

    public static WebConverters of(ObjectMapper mapper, List<HypermediaMappingInformation> mappingInformations) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull(mappingInformations, (String)"Mapping information must not be null!");
        return new WebConverters(mapper, mappingInformations);
    }

    public void augment(List<HttpMessageConverter<?>> converters) {
        Assert.notNull(converters, (String)"HttpMessageConverters must not be null!");
        this.converters.forEach(it -> converters.add(0, (HttpMessageConverter<?>)it));
    }

    public List<HttpMessageConverter<?>> and(Collection<HttpMessageConverter<?>> converters) {
        Assert.notNull(converters, (String)"HttpMessageConverters must not be null!");
        ArrayList result = new ArrayList(this.converters);
        result.addAll(converters);
        return result;
    }

    private static AbstractJackson2HttpMessageConverter createMessageConverter(HypermediaMappingInformation type, ObjectMapper mapper) {
        return new TypeConstrainedMappingJackson2HttpMessageConverter(RepresentationModel.class, type.getMediaTypes(), type.configureObjectMapper(mapper));
    }
}

