/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.ContextualSerializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.HandlerInstantiator;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.deser.std.ContainerDeserializerBase;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.ContainerSerializerBase;
import org.codehaus.jackson.map.ser.std.MapSerializer;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.hal.HalEmbeddedBuilder;
import org.springframework.hateoas.hal.LinkMixin;
import org.springframework.hateoas.hal.ResourceSupportMixin;
import org.springframework.hateoas.hal.ResourcesMixin;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated
public class Jackson1HalModule
extends SimpleModule {
    public Jackson1HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(ResourceSupport.class, ResourceSupportMixin.class);
        this.setMixInAnnotation(Resources.class, ResourcesMixin.class);
    }

    public static class HalHandlerInstantiator
    extends HandlerInstantiator {
        private final Map<Class<?>, Object> instanceMap = new HashMap();

        public HalHandlerInstantiator(RelProvider relProvider) {
            Assert.notNull((Object)relProvider, (String)"RelProvider must not be null!");
            this.instanceMap.put(HalResourcesSerializer.class, (Object)new HalResourcesSerializer(null, relProvider));
        }

        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<? extends JsonDeserializer<?>> deserClass) {
            return (JsonDeserializer)this.findInstance(deserClass, false);
        }

        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<? extends KeyDeserializer> keyDeserClass) {
            return (KeyDeserializer)this.findInstance(keyDeserClass, false);
        }

        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<? extends JsonSerializer<?>> serClass) {
            return (JsonSerializer)this.findInstance(serClass, true);
        }

        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<? extends TypeResolverBuilder<?>> builderClass) {
            return (TypeResolverBuilder)this.findInstance(builderClass, false);
        }

        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<? extends TypeIdResolver> resolverClass) {
            return (TypeIdResolver)this.findInstance(resolverClass, false);
        }

        private Object findInstance(Class<?> type, boolean createInstance) {
            Object result = this.instanceMap.get(type);
            if (result != null) {
                return result;
            }
            return createInstance ? BeanUtils.instantiateClass(type) : null;
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer<List<Object>> {
        private final JavaType contentType;

        public HalResourcesDeserializer() {
            this(List.class, null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this(null, vc);
        }

        private HalResourcesDeserializer(Class<?> type, JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer deser = ctxt.getDeserializerProvider().findTypedValueDeserializer(ctxt.getConfig(), this.contentType, null);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JsonDeserializer<List<Object>> createContextual(DeserializationConfig config, BeanProperty property) throws JsonMappingException {
            JavaType vc = property.getType().getContentType();
            HalResourcesDeserializer des = new HalResourcesDeserializer(vc);
            return des;
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        public HalLinkListDeserializer() {
            super(List.class);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                String relation = jp.getText();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        result.add(this.getDefaultedLink(jp, relation));
                    }
                    continue;
                }
                result.add(this.getDefaultedLink(jp, relation));
            }
            return result;
        }

        private Link getDefaultedLink(JsonParser parser, String relation) throws JsonProcessingException, IOException {
            Link link = (Link)parser.readValueAs(Link.class);
            return StringUtils.hasText((String)link.getRel()) ? link : new Link(link.getHref(), relation);
        }
    }

    public static class OptionalListSerializer
    extends ContainerSerializerBase<Object> {
        private final BeanProperty property;
        private JsonSerializer<Object> serializer;

        public OptionalListSerializer() {
            this(null);
        }

        public OptionalListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            List list = (List)value;
            if (list.size() == 1) {
                this.serializeContents(list.iterator(), jgen, provider);
                return;
            }
            jgen.writeStartArray();
            this.serializeContents(list.iterator(), jgen, provider);
            jgen.writeEndArray();
        }

        private void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            while (value.hasNext()) {
                Object elem = value.next();
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (this.serializer == null) {
                    this.serializer = provider.findValueSerializer(elem.getClass(), this.property);
                }
                this.serializer.serialize(elem, jgen, provider);
            }
        }
    }

    public static class HalResourcesSerializer
    extends ContainerSerializerBase<Collection<?>>
    implements ContextualSerializer<Collection<?>> {
        private final BeanProperty property;
        private final RelProvider relProvider;

        public HalResourcesSerializer(RelProvider relProvider) {
            this(null, relProvider);
        }

        public HalResourcesSerializer(BeanProperty property, RelProvider relProvider) {
            super(Collection.class, false);
            this.property = property;
            this.relProvider = relProvider;
        }

        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HalEmbeddedBuilder builder = new HalEmbeddedBuilder(this.relProvider, false);
            for (Object resource : value) {
                builder.add(resource);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Resource.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListSerializer(this.property));
            serializer.serialize(builder.asMap(), jgen, provider);
        }

        public JsonSerializer<Collection<?>> createContextual(SerializationConfig config, BeanProperty property) throws JsonMappingException {
            return new HalResourcesSerializer(property, this.relProvider);
        }

        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializerBase<List<Link>>
    implements ContextualSerializer<List<Link>> {
        private final BeanProperty property;

        public HalLinkListSerializer() {
            this(null);
        }

        public HalLinkListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public void serialize(List<Link> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            LinkedHashMap sortedLinks = new LinkedHashMap();
            for (Link link : value) {
                if (sortedLinks.get(link.getRel()) == null) {
                    sortedLinks.put(link.getRel(), new ArrayList());
                }
                ((List)sortedLinks.get(link.getRel())).add(link);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Link.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListSerializer(this.property));
            serializer.serialize(sortedLinks, jgen, provider);
        }

        public JsonSerializer<List<Link>> createContextual(SerializationConfig config, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property);
        }

        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

