/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.lang.annotation.Annotation;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class AuthenticationPrincipalArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final BeanResolver beanResolver;

    public AuthenticationPrincipalArgumentResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, (String)"BeanResolver is required");
        this.beanResolver = beanResolver;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AuthenticationPrincipalArgumentResolver.findMethodAnnotation(parameter) != null;
    }

    private static @Nullable AuthenticationPrincipal findMethodAnnotation(MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        AuthenticationPrincipal annotation = (AuthenticationPrincipal)parameter.getParameterAnnotation(AuthenticationPrincipal.class);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = (AuthenticationPrincipal)AnnotationUtils.findAnnotation(toSearch.annotationType(), AuthenticationPrincipal.class);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public @Nullable Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        return this.getCurrentAuthentication(parameter).mapNotNull(auth -> this.resolvePrincipal(parameter, auth.getPrincipal())).transform(argument -> AuthenticationPrincipalArgumentResolver.isPublisherOrMono(parameter) ? Mono.just((Object)argument) : argument);
    }

    private static boolean isPublisherOrMono(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return Publisher.class.equals((Object)type) || Mono.class.equals((Object)type);
    }

    private Mono<Authentication> getCurrentAuthentication(MethodParameter parameter) {
        Mono mono;
        Object value = PrincipalMethodArgumentResolver.resolveAuthentication(parameter);
        if (value instanceof Authentication) {
            Authentication auth = (Authentication)value;
            mono = Mono.just((Object)auth);
        } else {
            mono = (Mono)value;
        }
        return mono;
    }

    private @Nullable Object resolvePrincipal(MethodParameter parameter, @Nullable Object principal) {
        AuthenticationPrincipal annotation = AuthenticationPrincipalArgumentResolver.findMethodAnnotation(parameter);
        if (annotation != null && StringUtils.hasLength((String)annotation.expression())) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(principal);
            context.setVariable("this", principal);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(annotation.expression());
            principal = expression.getValue((EvaluationContext)context);
        }
        if (this.isInvalidType(parameter, principal)) {
            if (annotation != null && annotation.errorOnInvalidType()) {
                throw new ClassCastException(String.valueOf(principal) + " is not assignable to " + String.valueOf(parameter.getParameterType()));
            }
            return null;
        }
        return principal;
    }

    private boolean isInvalidType(MethodParameter parameter, @Nullable Object principal) {
        if (principal == null) {
            return false;
        }
        Class typeToCheck = parameter.getParameterType();
        if (AuthenticationPrincipalArgumentResolver.isPublisherOrMono(parameter)) {
            Class genericType = parameter.nested().getNestedParameterType();
            if (genericType.equals(Object.class)) {
                return false;
            }
            typeToCheck = genericType;
        }
        return !ClassUtils.isAssignable((Class)typeToCheck, principal.getClass());
    }
}

