/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.ArgumentValue;
import tools.jackson.core.Version;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.std.ReferenceTypeSerializer;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.type.TypeBindings;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.type.TypeModifier;
import tools.jackson.databind.util.NameTransformer;

public class GraphQlJacksonModule
extends JacksonModule {
    public String getModuleName() {
        return GraphQlJacksonModule.class.getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(JacksonModule.SetupContext context) {
        context.addSerializers((Serializers)new GraphQlSerializers());
        context.addTypeModifier((TypeModifier)new ArgumentValueTypeModifier());
        context.configOverride(ArgumentValue.class).setInclude(JsonInclude.Value.empty().withValueInclusion(JsonInclude.Include.NON_ABSENT));
    }

    static class GraphQlSerializers
    extends Serializers.Base {
        GraphQlSerializers() {
        }

        public @Nullable ValueSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, @Nullable TypeSerializer contentTypeSerializer, ValueSerializer<Object> contentValueSerializer) {
            Class raw = type.getRawClass();
            if (ArgumentValue.class.isAssignableFrom(raw)) {
                boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
                return new ArgumentValueSerializer(type, staticTyping, contentTypeSerializer, contentValueSerializer);
            }
            return null;
        }
    }

    static class ArgumentValueTypeModifier
    extends TypeModifier {
        ArgumentValueTypeModifier() {
        }

        public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
            Class raw = type.getRawClass();
            if (!type.isReferenceType() && !type.isContainerType() && raw == ArgumentValue.class) {
                JavaType refType = type.containedTypeOrUnknown(0);
                return ReferenceType.upgradeFrom((JavaType)type, (JavaType)refType);
            }
            return type;
        }
    }

    static class ArgumentValueSerializer
    extends ReferenceTypeSerializer<ArgumentValue<?>> {
        ArgumentValueSerializer(ReferenceType fullType, boolean staticTyping, @Nullable TypeSerializer vts, ValueSerializer<Object> ser) {
            super(fullType, staticTyping, vts, ser);
        }

        ArgumentValueSerializer(ReferenceTypeSerializer<?> base, BeanProperty property, TypeSerializer vts, ValueSerializer<?> valueSer, NameTransformer unwrapper, Object suppressableValue, boolean suppressNulls) {
            super(base, property, vts, valueSer, unwrapper, suppressableValue, suppressNulls);
        }

        protected ReferenceTypeSerializer<ArgumentValue<?>> withResolved(BeanProperty prop, TypeSerializer vts, ValueSerializer<?> valueSer, NameTransformer unwrapper) {
            return new ArgumentValueSerializer(this, prop, vts, valueSer, unwrapper, this._suppressableValue, this._suppressNulls);
        }

        public ReferenceTypeSerializer<ArgumentValue<?>> withContentInclusion(Object suppressableValue, boolean suppressNulls) {
            return new ArgumentValueSerializer(this, this._property, this._valueTypeSerializer, this._valueSerializer, this._unwrapper, suppressableValue, suppressNulls);
        }

        protected boolean _isValuePresent(ArgumentValue<?> value) {
            return !value.isOmitted();
        }

        protected @Nullable Object _getReferenced(ArgumentValue<?> value) {
            return value.value();
        }

        protected @Nullable Object _getReferencedIfPresent(ArgumentValue<?> value) {
            return value.value();
        }
    }
}

