/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.DefaultTransportGraphQlClientBuilder;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.SyncGraphQlClientInterceptor;
import org.springframework.graphql.support.DocumentSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public interface GraphQlClient {
    public RequestSpec document(String var1);

    public RequestSpec documentName(String var1);

    public BaseBuilder<?> mutate();

    public static Builder<?> builder(GraphQlTransport transport) {
        return new DefaultTransportGraphQlClientBuilder(transport);
    }

    public static interface RetrieveSubscriptionSpec {
        public <D> Flux<D> toEntity(Class<D> var1);

        public <D> Flux<D> toEntity(ParameterizedTypeReference<D> var1);

        public <D> Flux<List<D>> toEntityList(Class<D> var1);

        public <D> Flux<List<D>> toEntityList(ParameterizedTypeReference<D> var1);
    }

    public static interface RetrieveSpec {
        public <D> Mono<D> toEntity(Class<D> var1);

        public <D> Mono<D> toEntity(ParameterizedTypeReference<D> var1);

        public <D> Mono<List<D>> toEntityList(Class<D> var1);

        public <D> Mono<List<D>> toEntityList(ParameterizedTypeReference<D> var1);
    }

    public static interface RetrieveSyncSpec {
        public <D> @Nullable D toEntity(Class<D> var1);

        public <D> @Nullable D toEntity(ParameterizedTypeReference<D> var1);

        public <D> List<D> toEntityList(Class<D> var1);

        public <D> List<D> toEntityList(ParameterizedTypeReference<D> var1);
    }

    public static interface RequestSpec {
        public RequestSpec operationName(@Nullable String var1);

        public RequestSpec variable(String var1, @Nullable Object var2);

        public RequestSpec variables(Map<String, Object> var1);

        public RequestSpec extension(String var1, @Nullable Object var2);

        public RequestSpec extensions(Map<String, Object> var1);

        public RequestSpec attribute(String var1, Object var2);

        public RequestSpec attributes(Consumer<Map<String, Object>> var1);

        public RetrieveSyncSpec retrieveSync(String var1);

        public RetrieveSpec retrieve(String var1);

        public RetrieveSubscriptionSpec retrieveSubscription(String var1);

        public ClientGraphQlResponse executeSync();

        public Mono<ClientGraphQlResponse> execute();

        public Flux<ClientGraphQlResponse> executeSubscription();
    }

    public static interface Builder<B extends Builder<B>>
    extends BaseBuilder<B> {
        public B interceptor(GraphQlClientInterceptor ... var1);

        public B interceptors(Consumer<List<GraphQlClientInterceptor>> var1);
    }

    public static interface SyncBuilder<B extends SyncBuilder<B>>
    extends BaseBuilder<B> {
        public B interceptor(SyncGraphQlClientInterceptor ... var1);

        public B interceptors(Consumer<List<SyncGraphQlClientInterceptor>> var1);

        public B scheduler(Scheduler var1);
    }

    public static interface BaseBuilder<B extends BaseBuilder<B>> {
        public B documentSource(DocumentSource var1);

        public B blockingTimeout(@Nullable Duration var1);

        public GraphQlClient build();
    }
}

