/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public final class HttpRequestHeaderInterceptor
implements WebGraphQlInterceptor {
    private final List<BiConsumer<HttpHeaders, Map<String, Object>>> mappers;

    private HttpRequestHeaderInterceptor(List<BiConsumer<HttpHeaders, Map<String, Object>>> mappers) {
        this.mappers = new ArrayList<BiConsumer<HttpHeaders, Map<String, Object>>>(mappers);
    }

    @Override
    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        request.configureExecutionInput((executionInput, builder) -> {
            HttpHeaders headers = request.getHeaders();
            HashMap target = new HashMap(this.mappers.size());
            this.mappers.forEach(mapper -> mapper.accept(headers, target));
            builder.graphQLContext(target);
            return builder.build();
        });
        return chain.next(request);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final List<BiConsumer<HttpHeaders, Map<String, Object>>> mappers = new ArrayList<BiConsumer<HttpHeaders, Map<String, Object>>>();

        private DefaultBuilder() {
        }

        @Override
        public DefaultBuilder mapHeader(String ... headers) {
            for (String header : headers) {
                this.initMapper(header, null);
            }
            return this;
        }

        @Override
        public DefaultBuilder mapHeaderToKey(String header, String contextKey) {
            this.initMapper(header, contextKey);
            return this;
        }

        private void initMapper(String header, @Nullable String key) {
            this.mappers.add((headers, target) -> {
                String value = headers.getFirst(header);
                if (value != null) {
                    target.put(key != null ? key : header, value);
                }
            });
        }

        @Override
        public DefaultBuilder mapMultiValueHeader(String ... headers) {
            for (String header : headers) {
                this.initMultiValueMapper(header, null);
            }
            return this;
        }

        @Override
        public DefaultBuilder mapMultiValueHeaderToKey(String header, String contextKey) {
            this.initMultiValueMapper(header, contextKey);
            return this;
        }

        private void initMultiValueMapper(String header, @Nullable String key) {
            this.mappers.add((headers, target) -> {
                List list = headers.getValuesAsList(header);
                if (!ObjectUtils.isEmpty((Object)list)) {
                    target.put(key != null ? key : header, list);
                }
            });
        }

        @Override
        public HttpRequestHeaderInterceptor build() {
            return new HttpRequestHeaderInterceptor(this.mappers);
        }
    }

    public static interface Builder {
        public Builder mapHeader(String ... var1);

        public Builder mapHeaderToKey(String var1, String var2);

        public Builder mapMultiValueHeader(String ... var1);

        public Builder mapMultiValueHeaderToKey(String var1, String var2);

        public HttpRequestHeaderInterceptor build();
    }
}

