/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.WiringFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.util.Assert;

class AutoRegistrationRuntimeWiringConfigurer
implements RuntimeWiringConfigurer {
    private static final Log logger = LogFactory.getLog(AutoRegistrationRuntimeWiringConfigurer.class);
    private final Map<String, DataFetcherFactory> dataFetcherFactories;

    AutoRegistrationRuntimeWiringConfigurer(Map<String, DataFetcherFactory> factories) {
        this.dataFetcherFactories = factories;
    }

    @Override
    public void configure(RuntimeWiring.Builder builder) {
    }

    @Override
    public void configure(RuntimeWiring.Builder builder, List<WiringFactory> container) {
        container.add(new AutoRegistrationWiringFactory(builder));
    }

    private class AutoRegistrationWiringFactory
    implements WiringFactory {
        private final RuntimeWiring.Builder builder;
        private @Nullable Predicate<String> existingQueryDataFetcherPredicate;

        AutoRegistrationWiringFactory(RuntimeWiring.Builder builder) {
            this.builder = builder;
        }

        public boolean providesDataFetcher(FieldWiringEnvironment environment) {
            boolean result;
            if (AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.isEmpty()) {
                return false;
            }
            if (!environment.getParentType().getName().equals("Query")) {
                return false;
            }
            String outputTypeName = this.getOutputTypeName(environment);
            boolean bl = result = outputTypeName != null && AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.containsKey(outputTypeName) && !this.hasDataFetcherFor(environment.getFieldDefinition());
            if (!result) {
                this.logTraceMessage(environment, outputTypeName, false);
            }
            return result;
        }

        private @Nullable String getOutputTypeName(FieldWiringEnvironment environment) {
            GraphQLType outputType = this.removeNonNullWrapper((GraphQLType)environment.getFieldType());
            if (this.isConnectionType(outputType)) {
                String name = ((GraphQLObjectType)outputType).getName();
                return name.substring(0, name.length() - 10);
            }
            if (outputType instanceof GraphQLList) {
                outputType = this.removeNonNullWrapper(((GraphQLList)outputType).getWrappedType());
            }
            if (outputType instanceof GraphQLNamedOutputType) {
                GraphQLNamedOutputType namedType = (GraphQLNamedOutputType)outputType;
                return namedType.getName();
            }
            return null;
        }

        private GraphQLType removeNonNullWrapper(GraphQLType outputType) {
            GraphQLType graphQLType;
            if (outputType instanceof GraphQLNonNull) {
                GraphQLNonNull wrapper = (GraphQLNonNull)outputType;
                graphQLType = wrapper.getWrappedType();
            } else {
                graphQLType = outputType;
            }
            return graphQLType;
        }

        private boolean isConnectionType(GraphQLType type) {
            GraphQLObjectType objectType;
            return type instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)type).getName().endsWith("Connection") && objectType.getField("edges") != null && objectType.getField("pageInfo") != null;
        }

        private boolean hasDataFetcherFor(FieldDefinition fieldDefinition) {
            if (this.existingQueryDataFetcherPredicate == null) {
                Map map = this.builder.build().getDataFetcherForType("Query");
                this.existingQueryDataFetcherPredicate = fieldName -> map.get(fieldName) != null;
            }
            return this.existingQueryDataFetcherPredicate.test(fieldDefinition.getName());
        }

        private void logTraceMessage(FieldWiringEnvironment environment, @Nullable String typeName, boolean match) {
            if (logger.isTraceEnabled()) {
                String query = environment.getFieldDefinition().getName();
                logger.trace((Object)((match ? "Matched" : "Skipped") + " output typeName " + (String)(typeName != null ? "'" + typeName + "'" : "null") + " for query '" + query + "'"));
            }
        }

        public DataFetcher<?> getDataFetcher(FieldWiringEnvironment environment) {
            String outputTypeName = this.getOutputTypeName(environment);
            this.logTraceMessage(environment, outputTypeName, true);
            DataFetcherFactory factory = AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.get(outputTypeName);
            Assert.notNull((Object)factory, (String)("Expected DataFetcher factory for typeName '" + outputTypeName + "'"));
            GraphQLType type = this.removeNonNullWrapper((GraphQLType)environment.getFieldType());
            return this.isConnectionType(type) ? factory.scrollable() : (type instanceof GraphQLList ? factory.many() : factory.single());
        }
    }

    static interface DataFetcherFactory {
        public DataFetcher<?> single();

        public DataFetcher<?> many();

        public DataFetcher<?> scrollable();
    }
}

