/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.InvocableHandlerMethodSupport;
import org.springframework.util.ObjectUtils;

public class DataFetcherHandlerMethodSupport
extends InvocableHandlerMethodSupport {
    private static final Object[] EMPTY_ARGS = new Object[0];
    protected final HandlerMethodArgumentResolverComposite resolvers;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    protected DataFetcherHandlerMethodSupport(HandlerMethod handlerMethod, HandlerMethodArgumentResolverComposite resolvers, @Nullable Executor executor, boolean invokeAsync) {
        super(handlerMethod, executor, invokeAsync);
        this.resolvers = resolvers;
    }

    public HandlerMethodArgumentResolverComposite getResolvers() {
        return this.resolvers;
    }

    protected @Nullable Object[] getMethodArgumentValues(DataFetchingEnvironment environment, Object ... providedArgs) throws Exception {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])parameters)) {
            return EMPTY_ARGS;
        }
        @Nullable Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            args[i] = DataFetcherHandlerMethodSupport.findProvidedArgument((MethodParameter)parameter, providedArgs);
            if (args[i] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new IllegalStateException(DataFetcherHandlerMethodSupport.formatArgumentError((MethodParameter)parameter, "No suitable resolver"));
            }
            try {
                args[i] = this.resolvers.resolveArgument((MethodParameter)parameter, environment);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(parameter.getExecutable().toGenericString())) {
                    logger.debug((Object)DataFetcherHandlerMethodSupport.formatArgumentError((MethodParameter)parameter, exMsg));
                }
                throw ex;
            }
        }
        return args;
    }
}

