/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import graphql.ExecutionInput;
import graphql.execution.ExecutionId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.support.DefaultGraphQlRequest;
import org.springframework.util.Assert;

public class DefaultExecutionGraphQlRequest
extends DefaultGraphQlRequest
implements ExecutionGraphQlRequest {
    private final String id;
    private @Nullable ExecutionId executionId;
    private final Locale locale;
    private final List<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>> executionInputConfigurers = new ArrayList<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>>();

    public DefaultExecutionGraphQlRequest(String document, @Nullable String operationName, @Nullable Map<String, Object> variables, @Nullable Map<String, Object> extensions, String id, @Nullable Locale locale) {
        super(document, operationName, variables, extensions);
        Assert.notNull((Object)id, (String)"'id' is required");
        this.id = id;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void executionId(ExecutionId executionId) {
        Assert.notNull((Object)executionId, (String)"executionId is required");
        this.executionId = executionId;
    }

    @Override
    public @Nullable ExecutionId getExecutionId() {
        return this.executionId;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void configureExecutionInput(BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> configurer) {
        this.executionInputConfigurers.add(configurer);
    }

    @Override
    public ExecutionInput toExecutionInput() {
        ExecutionInput.Builder inputBuilder = ExecutionInput.newExecutionInput().query(this.getDocument()).operationName(this.getOperationName()).variables(this.getVariables()).extensions(this.getExtensions()).locale(this.locale).executionId(this.executionId != null ? this.executionId : ExecutionId.from((String)this.id));
        ExecutionInput executionInput = inputBuilder.build();
        for (BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> configurer : this.executionInputConfigurers) {
            ExecutionInput current = executionInput;
            executionInput = executionInput.transform(builder -> configurer.apply(current, (ExecutionInput.Builder)builder));
        }
        return executionInput;
    }

    @Override
    public String toString() {
        return super.toString() + ", id=" + this.getId() + ", Locale=" + String.valueOf(this.getLocale());
    }
}

