/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.Arguments;
import org.springframework.util.Assert;

public class ArgumentsMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final GraphQlArgumentBinder argumentBinder;

    public ArgumentsMethodArgumentResolver(GraphQlArgumentBinder argumentBinder) {
        Assert.notNull((Object)argumentBinder, (String)"GraphQlArgumentBinder is required");
        this.argumentBinder = argumentBinder;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(Arguments.class) != null;
    }

    @Override
    public @Nullable Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
        return this.argumentBinder.bind(environment, null, resolvableType);
    }
}

