/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import java.util.Collection;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.graphql.data.pagination.ConnectionAdapterSupport;
import org.springframework.graphql.data.pagination.CursorStrategy;

public final class WindowConnectionAdapter
extends ConnectionAdapterSupport<ScrollPosition>
implements ConnectionAdapter {
    public WindowConnectionAdapter(CursorStrategy<ScrollPosition> strategy) {
        super(strategy);
    }

    @Override
    public boolean supports(Class<?> containerType) {
        return Window.class.isAssignableFrom(containerType);
    }

    @Override
    public <T> Collection<T> getContent(Object container) {
        Window<T> window = this.window(container);
        return window.getContent();
    }

    @Override
    public boolean hasPrevious(Object container) {
        Window window = this.window(container);
        if (!window.isEmpty()) {
            ScrollPosition position = window.positionAt(0);
            if (position instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPosition = (KeysetScrollPosition)position;
                return keysetPosition.scrollsBackward() && window.hasNext();
            }
            if (position instanceof OffsetScrollPosition) {
                OffsetScrollPosition offsetPosition = (OffsetScrollPosition)position;
                return offsetPosition.getOffset() != 0L;
            }
            return !position.isInitial();
        }
        return false;
    }

    @Override
    public boolean hasNext(Object container) {
        Window window = this.window(container);
        if (!window.isEmpty()) {
            ScrollPosition pos = window.positionAt(0);
            if (pos instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPos = (KeysetScrollPosition)pos;
                return keysetPos.scrollsForward() && window.hasNext();
            }
            return window.hasNext();
        }
        return false;
    }

    @Override
    public String cursorAt(Object container, int index) {
        ScrollPosition position = this.window(container).positionAt(index);
        return this.getCursorStrategy().toCursor(position);
    }

    private <T> Window<T> window(Object container) {
        return (Window)container;
    }
}

