/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.graphql.data.pagination.Subrange;
import org.springframework.lang.Nullable;

public final class ScrollSubrange
extends Subrange<ScrollPosition> {
    private ScrollSubrange(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward) {
        super(pos, count, forward);
    }

    public static ScrollSubrange create(@Nullable ScrollPosition position, @Nullable Integer count, boolean forward) {
        if (count != null && count < 0) {
            count = null;
        }
        if (position instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)position;
            return ScrollSubrange.initFromOffsetPosition(offsetScrollPosition, count, forward);
        }
        if (position instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)position;
            return ScrollSubrange.initFromKeysetPosition(keysetScrollPosition, count, forward);
        }
        return new ScrollSubrange(position, count, forward);
    }

    private static ScrollSubrange initFromOffsetPosition(OffsetScrollPosition position, @Nullable Integer count, boolean forward) {
        if (!forward) {
            int advanceCount;
            int n = advanceCount = count != null ? count : 1;
            if (position.getOffset() >= (long)(++advanceCount)) {
                position = position.advanceBy((long)(-advanceCount));
            } else {
                count = (int)position.getOffset();
                position = ScrollPosition.offset();
            }
        }
        return new ScrollSubrange((ScrollPosition)position, count, true);
    }

    private static ScrollSubrange initFromKeysetPosition(KeysetScrollPosition position, @Nullable Integer count, boolean forward) {
        if (!forward) {
            position = position.backward();
        }
        return new ScrollSubrange((ScrollPosition)position, count, forward);
    }
}

