/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.data;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.context.index.CandidateComponentsIndex;
import org.springframework.context.index.CandidateComponentsIndexLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.data.repository.config.ImplementationDetectionConfiguration;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.stereotype.Component;

@TargetClass(className="org.springframework.data.repository.config.CustomRepositoryImplementationDetector", onlyWith={OnlyIfPresent.class})
public final class Target_CustomRepositoryImplementationDetector {
    @Substitute
    private Set<BeanDefinition> findCandidateBeanDefinitions(final ImplementationDetectionConfiguration config) {
        final CandidateComponentsIndex index = CandidateComponentsIndexLoader.loadIndex((ClassLoader)config.getClass().getClassLoader());
        return config.getBasePackages().stream().flatMap(new Function<String, Stream<? extends BeanDefinition>>(){

            @Override
            public Stream<? extends BeanDefinition> apply(String basePackage) {
                Set candidateTypes = index.getCandidateTypes(basePackage, Component.class.getName());
                if (candidateTypes.isEmpty()) {
                    return Stream.empty();
                }
                LinkedHashSet<ScannedGenericBeanDefinition> beanDefinitions = new LinkedHashSet<ScannedGenericBeanDefinition>();
                for (String candidate : candidateTypes) {
                    if (!candidate.endsWith(config.getImplementationPostfix())) continue;
                    try {
                        MetadataReader metadataReader = config.getMetadataReaderFactory().getMetadataReader(candidate);
                        ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                        sbd.setResource(metadataReader.getResource());
                        beanDefinitions.add(sbd);
                    }
                    catch (IOException ex) {
                        throw new BeanDefinitionStoreException(String.format("Failure while reading metadata for %s.", candidate), (Throwable)ex);
                    }
                }
                return beanDefinitions.stream();
            }
        }).collect(Collectors.toSet());
    }
}

