/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.boot;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.springframework.boot.origin.Origin;

final class NativeSpringBootVersion {
    private static String VERSION = NativeSpringBootVersion.determineSpringBootVersion();

    private NativeSpringBootVersion() {
    }

    public static String getVersion() {
        return VERSION;
    }

    private static String determineSpringBootVersion() {
        String string;
        String implementationVersion = Origin.class.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        CodeSource codeSource = Origin.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL codeSourceLocation = codeSource.getLocation();
        URLConnection connection = codeSourceLocation.openConnection();
        if (connection instanceof JarURLConnection) {
            return NativeSpringBootVersion.getImplementationVersion(((JarURLConnection)connection).getJarFile());
        }
        JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));
        try {
            string = NativeSpringBootVersion.getImplementationVersion(jarFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

