/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcHints;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.hateoas.config.HateoasHints;
import org.springframework.nativex.domain.proxies.JdkProxyDescriptor;
import org.springframework.nativex.hint.JdkProxyHint;
import org.springframework.nativex.hint.NativeHint;
import org.springframework.nativex.hint.TypeAccess;
import org.springframework.nativex.hint.TypeHint;
import org.springframework.nativex.type.AccessDescriptor;
import org.springframework.nativex.type.HintDeclaration;
import org.springframework.nativex.type.MissingTypeException;
import org.springframework.nativex.type.NativeConfiguration;
import org.springframework.nativex.type.Type;
import org.springframework.nativex.type.TypeName;
import org.springframework.nativex.type.TypeProcessor;
import org.springframework.nativex.type.TypeSystem;
import org.springframework.nativex.type.TypeSystemNativeConfiguration;

@NativeHint(trigger=RepositoryRestMvcAutoConfiguration.class, types={@TypeHint(types={RepositoryFactoryInformation.class, Repositories.class, RepositoryInvoker.class, RepositoryInvokerFactory.class}, typeNames={"org.springframework.data.rest.core.annotation.Description", "org.springframework.data.rest.webmvc.RepositoryRestController", "org.springframework.data.rest.webmvc.BasePathAwareController", "org.atteo.evo.inflector.English"}, access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS})}, jdkProxies={@JdkProxyHint(typeNames={"org.springframework.data.rest.webmvc.BasePathAwareController", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.data.rest.webmvc.RepositoryRestController", "org.springframework.data.rest.webmvc.BasePathAwareController", "org.springframework.core.annotation.SynthesizedAnnotation"})}, imports={WebMvcHints.class, HateoasHints.class})
public class DataRestHints
implements NativeConfiguration,
TypeSystemNativeConfiguration {
    private static final String BASE_PATH_AWARE_CONTROLLER = "Lorg/springframework/data/rest/webmvc/BasePathAwareController;";
    private static final String REPOSITORY_REST_CONFIGURER = "org/springframework/data/rest/webmvc/config/RepositoryRestConfigurer";
    private static final String REPOSITORY_REST_RESOURCE = "Lorg/springframework/data/rest/core/annotation/RepositoryRestResource;";
    private static final String JACKSON_ANNOTATION = "Lcom/fasterxml/jackson/annotation/JacksonAnnotation;";

    public List<HintDeclaration> computeHints(TypeSystem typeSystem) {
        ArrayList<HintDeclaration> hints = new ArrayList<HintDeclaration>();
        hints.addAll(this.computeRestControllerHints(typeSystem));
        hints.addAll(this.computeRepositoryRestConfigurer(typeSystem));
        hints.addAll(this.computeExcerptProjectionHints(typeSystem));
        hints.addAll(this.computeJacksonMappingCandidates(typeSystem));
        return hints;
    }

    private List<HintDeclaration> computeRepositoryRestConfigurer(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"RestMvcConfigurationProcessor - RepositoryRestConfigurer").skipAnnotationInspection().skipMethodInspection().skipFieldInspection().skipConstructorInspection().onTypeDiscovered((type, context) -> context.addReflectiveAccess(type, new AccessDescriptor(Integer.valueOf(127)))).use(typeSystem).toProcessTypesMatching(it -> it.implementsInterface(REPOSITORY_REST_CONFIGURER, true));
    }

    private List<HintDeclaration> computeRestControllerHints(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"RestMvcConfigurationProcessor - RestController").skipTypesMatching(type -> !type.hasAnnotationInHierarchy(BASE_PATH_AWARE_CONTROLLER)).skipFieldInspection().skipConstructorInspection().filterAnnotations(annotation -> annotation.isPartOfDomain("org.springframework.web") || annotation.isPartOfDomain("org.springframework.data.rest")).use(typeSystem).toProcessTypes(ts -> ts.findTypesAnnotated(BASE_PATH_AWARE_CONTROLLER, true).stream().map(arg_0 -> ((TypeSystem)ts).resolveName(arg_0)));
    }

    private List<HintDeclaration> computeExcerptProjectionHints(TypeSystem typeSystem) {
        TypeProcessor.TypeHintCreatingProcessor excerptProjectionProcessor = TypeProcessor.namedProcessor((String)"RestMvcConfigurationProcessor - ExcerptProjection").skipFieldInspection().use(typeSystem);
        return typeSystem.findTypesAnnotated(REPOSITORY_REST_RESOURCE, true).stream().map(arg_0 -> ((TypeSystem)typeSystem).resolveName(arg_0)).flatMap(type -> {
            Map annotationValuesInHierarchy = type.getAnnotationValuesInHierarchy(REPOSITORY_REST_RESOURCE);
            if (!annotationValuesInHierarchy.containsKey("excerptProjection")) {
                return Stream.empty();
            }
            String excerptProjectionSignatureType = (String)annotationValuesInHierarchy.get("excerptProjection");
            Type targetProjectionType = typeSystem.resolve(TypeName.fromTypeSignature((String)excerptProjectionSignatureType));
            if (targetProjectionType == null || targetProjectionType.getDottedName().equals("org.springframework.data.rest.core.annotation.RepositoryRestResource$None")) {
                return Stream.empty();
            }
            ArrayList<HintDeclaration> projectionHints = new ArrayList<HintDeclaration>();
            projectionHints.addAll(excerptProjectionProcessor.toProcessType(targetProjectionType));
            HintDeclaration proxyHint = new HintDeclaration();
            JdkProxyDescriptor proxyDescriptor = new JdkProxyDescriptor(Arrays.asList(targetProjectionType.getDottedName(), "org.springframework.data.projection.TargetAware", "org.springframework.aop.SpringProxy", "org.springframework.core.DecoratingProxy"));
            proxyHint.addProxyDescriptor(proxyDescriptor);
            projectionHints.add(proxyHint);
            return projectionHints.stream();
        }).collect(Collectors.toList());
    }

    List<HintDeclaration> computeJacksonMappingCandidates(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"RestMvcConfigurationProcessor - Jackson Mapping Candidates").skipTypesMatching(type -> {
            if (type.isPartOfDomain("com.fasterxml.jackson.") || type.isPartOfDomain("java.")) {
                return true;
            }
            return type.isPartOfDomain("org.springframework.") && !type.isPartOfDomain("org.springframework.data.rest");
        }).filterAnnotations(annotation -> annotation.isPartOfDomain("com.fasterxml.jackson.")).use(typeSystem).toProcessTypesMatching(this::usesJackson);
    }

    private boolean usesJackson(Type type) {
        try {
            if (type.getAnnotations().stream().filter(ann -> ann.isAnnotated(JACKSON_ANNOTATION)).findAny().isPresent()) {
                return true;
            }
            if (!type.getMethodsWithAnnotation(JACKSON_ANNOTATION, true).isEmpty()) {
                return true;
            }
            return !type.getFieldsWithAnnotation(JACKSON_ANNOTATION, true).isEmpty();
        }
        catch (MissingTypeException missingTypeException) {
            return false;
        }
    }
}

