/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.context.support;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import org.springframework.aot.test.context.bootstrap.generator.AotTestContextProcessor;
import org.springframework.aot.test.context.support.AotDefaultConfigContextLoader;
import org.springframework.aot.test.context.support.DefaultBuildTimeConfigContextLoader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;

@Order(value=0x7FFFFFFF)
class DefaultAotTestContextProcessor
implements AotTestContextProcessor {
    private final DefaultBuildTimeConfigContextLoader contextLoader = new DefaultBuildTimeConfigContextLoader();

    DefaultAotTestContextProcessor() {
    }

    @Override
    public boolean supports(TestContextBootstrapper bootstrapper) {
        return bootstrapper instanceof DefaultTestContextBootstrapper;
    }

    @Override
    public GenericApplicationContext prepareTestContext(MergedContextConfiguration config) {
        try {
            return (GenericApplicationContext)this.contextLoader.loadContext(config);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to prepare test context using " + config, ex);
        }
    }

    @Override
    public CodeBlock writeInstanceSupplier(MergedContextConfiguration config, ClassName applicationContextInitializer) {
        return CodeBlock.of((String)"() -> new $T($T.class)", (Object[])new Object[]{AotDefaultConfigContextLoader.class, applicationContextInitializer});
    }
}

