/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.build;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.MultiValueMap;

public abstract class TestClassesFinder {
    public static final String EXTEND_WITH_ANNOTATION_NAME = "org.junit.jupiter.api.extension.ExtendWith";
    public static final String SPRING_EXTENSION_ANNOTATION_NAME = "org.springframework.test.context.junit.jupiter.SpringExtension";
    private static final FileFilter CLASS_FILE_FILTER = TestClassesFinder::isClassFile;
    private static final FileFilter PACKAGE_DIRECTORY_FILTER = TestClassesFinder::isPackageDirectory;

    public static List<String> findTestClasses(Path rootDirectoryPath) throws IOException {
        ArrayList<String> testClasses = new ArrayList<String>();
        SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();
        File rootDirectory = rootDirectoryPath.toFile();
        if (!rootDirectory.exists()) {
            return Collections.emptyList();
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid root directory '" + rootDirectory + "'");
        }
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(rootDirectory);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isFile()) {
                try {
                    List extendWithValues;
                    boolean isSpringTest;
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader((Resource)new FileSystemResource(file));
                    AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                    ClassMetadata classMetadata = metadataReader.getClassMetadata();
                    MultiValueMap extendWith = annotationMetadata.getAllAnnotationAttributes(EXTEND_WITH_ANNOTATION_NAME, true);
                    if (extendWith != null && (isSpringTest = (extendWithValues = (List)extendWith.getOrDefault((Object)"value", Collections.emptyList())).stream().flatMap(classNames -> Arrays.stream((String[])classNames)).anyMatch(className -> className.equals(SPRING_EXTENSION_ANNOTATION_NAME)))) {
                        testClasses.add(classMetadata.getClassName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!file.isDirectory()) continue;
            Arrays.stream(file.listFiles(PACKAGE_DIRECTORY_FILTER)).forEach(stack::push);
            Arrays.stream(file.listFiles(CLASS_FILE_FILTER)).forEach(stack::push);
        }
        return Collections.unmodifiableList(testClasses);
    }

    private static boolean isClassFile(File file) {
        return file.isFile() && file.getName().endsWith(".class");
    }

    private static boolean isPackageDirectory(File file) {
        return file.isDirectory() && !file.getName().startsWith(".");
    }
}

