/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.aot.BootstrapCodeGenerator;
import org.springframework.aot.maven.AbstractBootstrapMojo;

@Mojo(name="test-generate", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class TestGenerateMojo
extends AbstractBootstrapMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/spring-aot/")
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<Path> resourceFolders = new HashSet<Path>();
        for (Resource r : this.project.getTestResources()) {
            resourceFolders.add(new File(r.getDirectory()).toPath());
        }
        this.recreateGeneratedSourcesFolder(this.outputDirectory);
        Path sourcesPath = this.outputDirectory.toPath().resolve(Paths.get("src", "test", "java"));
        Path resourcesPath = this.outputDirectory.toPath().resolve(Paths.get("src", "test", "resources"));
        try {
            List testClasspathElements = this.project.getTestClasspathElements();
            BootstrapCodeGenerator generator = new BootstrapCodeGenerator(this.getAotOptions());
            generator.generate(sourcesPath, resourcesPath, testClasspathElements, resourceFolders);
            this.compileGeneratedTestSources(sourcesPath, testClasspathElements);
            this.processGeneratedTestResources(resourcesPath, Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
            this.buildContext.refresh(this.buildDir);
        }
        catch (Throwable exc) {
            logger.error((Object)exc);
            logger.error((Object)Arrays.toString(exc.getStackTrace()));
            throw new MojoFailureException("Build failed during Spring AOT test code generation", exc);
        }
    }
}

