/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.springframework.aot.maven.AbstractBootstrapMojo;
import org.springframework.aot.test.build.GenerateTestBootstrapCommand;
import org.springframework.util.StringUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="test-generate", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class TestGenerateMojo
extends AbstractBootstrapMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-runtime-test-sources/spring-aot/")
    private File generatedTestSourcesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path springProperties = Path.of(this.project.getBuild().getTestOutputDirectory(), "spring.properties");
            if (springProperties.toFile().exists()) {
                Files.delete(springProperties);
            }
            if ("true".equals(System.getProperty("skipTests")) || "true".equals(System.getProperty("maven.test.skip"))) {
                this.getLog().info((CharSequence)"Skip Spring AOT test generation since tests are skipped");
                return;
            }
            if ("false".equals(System.getProperty("springAot"))) {
                this.getLog().info((CharSequence)"Skip Spring AOT test generation since disabled with -DspringAot=false");
                return;
            }
            if (this.project.getPackaging().equals("pom")) {
                this.getLog().debug((CharSequence)"test-generate goal could not be applied to pom project.");
                return;
            }
            Path testOutputDirectory = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
            if (Files.notExists(testOutputDirectory, new LinkOption[0])) {
                this.getLog().info((CharSequence)"Skip Spring AOT test generation since no test have been detected");
                return;
            }
            List<String> testClasspathElements = this.project.getTestClasspathElements().stream().filter(element -> !element.contains("spring-boot-devtools")).collect(Collectors.toList());
            Files.createDirectories(this.generatedTestSourcesDirectory.toPath(), new FileAttribute[0]);
            Path sourcesPath = this.generatedTestSourcesDirectory.toPath().resolve(Paths.get("src", "test", "java"));
            Path resourcesPath = this.generatedTestSourcesDirectory.toPath().resolve(Paths.get("src", "test", "resources"));
            Files.createDirectories(sourcesPath, new FileAttribute[0]);
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.experimental", "spring-native-configuration").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.experimental", "spring-aot").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.experimental", "spring-aot-test").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.boot", "spring-boot-loader-tools").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "com.squareup", "javapoet").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "info.picocli", "picocli").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            TestGenerateMojo.findJarFile(this.pluginArtifacts, "net.bytebuddy", "byte-buddy").ifPresent(artifact -> TestGenerateMojo.prependDependency(artifact, testClasspathElements));
            HashSet<Path> resourceFolders = new HashSet<Path>();
            for (Resource r : this.project.getResources()) {
                resourceFolders.add(new File(r.getDirectory()).toPath());
            }
            for (Resource r : this.project.getTestResources()) {
                resourceFolders.add(new File(r.getDirectory()).toPath());
            }
            ArrayList<String> args = new ArrayList<String>();
            if ("true".equals(this.debug)) {
                args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8000");
            } else {
                args.addAll(Arrays.asList(CommandLineUtils.translateCommandline((String)this.debug)));
            }
            args.add("-cp");
            args.add(TestGenerateMojo.asClasspathArgument(testClasspathElements));
            args.add(GenerateTestBootstrapCommand.class.getCanonicalName());
            args.add("--sources-out=" + sourcesPath.toAbsolutePath());
            args.add("--resources-out=" + resourcesPath.toAbsolutePath());
            args.add("--resources=" + StringUtils.collectionToDelimitedString(resourceFolders, (String)File.pathSeparator));
            this.applyAotOptions(args);
            args.add(testOutputDirectory.toString());
            this.forkJvm(Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile(), args, Collections.emptyMap());
            this.compileGeneratedTestSources(sourcesPath);
            this.processGeneratedTestResources(resourcesPath, Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
            Files.write(springProperties, Collections.singletonList("spring.test.context.default.CacheAwareContextLoaderDelegate=org.springframework.aot.test.AotCacheAwareContextLoaderDelegate"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.buildContext.refresh(this.buildDir);
        }
        catch (Throwable exc) {
            this.getLog().error(exc);
            this.getLog().error((CharSequence)Arrays.toString(exc.getStackTrace()));
            throw new MojoFailureException("Build failed during Spring AOT test code generation", exc);
        }
    }

    protected void compileGeneratedTestSources(Path sourcesPath) throws MojoExecutionException {
        String compilerVersion = this.project.getProperties().getProperty("maven-compiler-plugin.version", "3.8.1");
        this.project.addTestCompileSourceRoot(sourcesPath.toString());
        Xpp3Dom compilerConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoots", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoot", (String)sourcesPath.toString())})});
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)compilerVersion)), (String)MojoExecutor.goal((String)"testCompile"), (Xpp3Dom)compilerConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void processGeneratedTestResources(Path sourcePath, Path destinationPath) throws MojoExecutionException {
        String resourcesVersion = this.project.getProperties().getProperty("maven-resources-plugin.version", "3.2.0");
        Xpp3Dom resourceConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)sourcePath.toString())})}), MojoExecutor.element((String)"outputDirectory", (String)destinationPath.toString())});
        Resource resource = new Resource();
        resource.setDirectory(sourcePath.toString());
        this.project.addTestResource(resource);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)resourcesVersion)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)resourceConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }
}

