/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.nativex.AotOptions;
import org.springframework.util.FileSystemUtils;

abstract class AbstractBootstrapMojo
extends AbstractMojo {
    static final String DEFAULT_COMPILER_PLUGIN_VERSION = "3.8.1";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected BuildContext buildContext;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(defaultValue="${plugin.artifacts}")
    protected List<Artifact> pluginArtifacts;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(property="spring.aot.debug")
    protected String debug;
    @Parameter
    protected String mode;
    @Parameter
    protected boolean debugVerify;
    @Parameter
    protected boolean verify = true;
    @Parameter
    protected boolean removeYamlSupport;
    @Parameter
    protected boolean removeJmxSupport = true;
    @Parameter
    protected boolean removeXmlSupport = true;
    @Parameter
    protected boolean removeSpelSupport;

    AbstractBootstrapMojo() {
    }

    protected AotOptions getAotOptions() {
        AotOptions aotOptions = new AotOptions();
        aotOptions.setMode(this.mode);
        aotOptions.setDebugVerify(this.debugVerify);
        aotOptions.setVerify(this.verify);
        aotOptions.setRemoveYamlSupport(this.removeYamlSupport);
        aotOptions.setRemoveJmxSupport(this.removeJmxSupport);
        aotOptions.setRemoveXmlSupport(this.removeXmlSupport);
        aotOptions.setRemoveSpelSupport(this.removeSpelSupport);
        return aotOptions;
    }

    protected void applyAotOptions(List<String> args) {
        AotOptions aotOptions = this.getAotOptions();
        args.add("--mode=" + aotOptions.toMode());
        if (aotOptions.isRemoveXmlSupport()) {
            args.add("--remove-xml");
        }
        if (aotOptions.isRemoveJmxSupport()) {
            args.add("--remove-jmx");
        }
        if (aotOptions.isRemoveSpelSupport()) {
            args.add("--remove-spel");
        }
        if (aotOptions.isRemoveYamlSupport()) {
            args.add("--remove-yaml");
        }
        if (this.getLogLevel().equals("DEBUG")) {
            args.add("--debug");
        }
    }

    protected static String asClasspathArgument(List<String> elements) {
        StringBuilder classpath = new StringBuilder();
        for (String element : elements) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(element);
        }
        return classpath.toString();
    }

    protected static Optional<Artifact> findJarFile(List<Artifact> artifacts, String groupId, String artifactId) {
        return artifacts.stream().filter(artifact -> artifact.getGroupId().equals(groupId) && artifact.getArtifactId().equals(artifactId)).findFirst();
    }

    protected static void prependDependency(Artifact artifact, List<String> classpathElements) {
        classpathElements.add(1, artifact.getFile().getAbsolutePath());
    }

    protected String getLogLevel() {
        if (this.getLog().isDebugEnabled()) {
            return "DEBUG";
        }
        if (this.getLog().isInfoEnabled()) {
            return "INFO";
        }
        if (this.getLog().isWarnEnabled()) {
            return "WARN";
        }
        return "ERROR";
    }

    protected void recreateGeneratedSourcesFolder(File generatedSourcesFolder) throws MojoFailureException {
        try {
            FileSystemUtils.deleteRecursively((File)generatedSourcesFolder);
            Files.createDirectories(generatedSourcesFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException exc) {
            throw new MojoFailureException("Build failed during Spring AOT code generation", (Throwable)exc);
        }
    }

    protected void forkJvm(File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException {
        try {
            RunProcess runProcess = new RunProcess(workingDirectory, new String[]{this.getJavaExecutable()});
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            int exitCode = runProcess.run(true, args, environmentVariables);
            if (exitCode == 0 || exitCode == 130) {
                return;
            }
            throw new MojoExecutionException("Bootstrap code generator finished with exit code: " + exitCode);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    protected String getJavaExecutable() {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        String javaExecutable = toolchain != null ? toolchain.findTool("java") : null;
        return javaExecutable != null ? javaExecutable : new JavaExecutable().toString();
    }

    protected static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

