/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.springframework.nativex.AotOptions;
import org.springframework.util.FileSystemUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

abstract class AbstractBootstrapMojo
extends AbstractMojo {
    private static final String DEFAULT_COMPILER_PLUGIN_VERSION = "3.8.1";
    protected static Log logger = LogFactory.getLog(AbstractBootstrapMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected BuildContext buildContext;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter
    protected String mode;
    @Parameter
    private boolean debugVerify;
    @Parameter
    private boolean ignoreHintsOnExcludedConfig;
    @Parameter
    private boolean removeUnusedConfig = true;
    @Parameter
    private boolean verify = true;
    @Parameter
    private boolean removeYamlSupport;
    @Parameter
    private boolean removeJmxSupport = true;
    @Parameter
    private boolean removeXmlSupport = true;
    @Parameter
    private boolean removeSpelSupport;
    @Parameter
    private boolean buildTimePropertiesMatchIfMissing;
    @Parameter
    private String[] buildTimePropertiesChecks;
    @Parameter
    private boolean failOnMissingSelectorHint;

    AbstractBootstrapMojo() {
    }

    protected AotOptions getAotOptions() {
        AotOptions aotOptions = new AotOptions();
        aotOptions.setMode(this.mode);
        aotOptions.setDebugVerify(this.debugVerify);
        aotOptions.setIgnoreHintsOnExcludedConfig(this.ignoreHintsOnExcludedConfig);
        aotOptions.setRemoveUnusedConfig(this.removeUnusedConfig);
        aotOptions.setVerify(this.verify);
        aotOptions.setRemoveYamlSupport(this.removeYamlSupport);
        aotOptions.setRemoveJmxSupport(this.removeJmxSupport);
        aotOptions.setRemoveXmlSupport(this.removeXmlSupport);
        aotOptions.setRemoveSpelSupport(this.removeSpelSupport);
        aotOptions.setBuildTimePropertiesMatchIfMissing(this.buildTimePropertiesMatchIfMissing);
        aotOptions.setBuildTimePropertiesChecks(this.buildTimePropertiesChecks);
        aotOptions.setFailOnMissingSelectorHint(this.failOnMissingSelectorHint);
        return aotOptions;
    }

    protected void recreateGeneratedSourcesFolder(File generatedSourcesFolder) throws MojoFailureException {
        try {
            FileSystemUtils.deleteRecursively((File)generatedSourcesFolder);
            Files.createDirectories(generatedSourcesFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException exc) {
            throw new MojoFailureException("Build failed during Spring AOT code generation", (Throwable)exc);
        }
    }

    protected void compileGeneratedSources(Path sourcesPath, List<String> runtimeClasspathElements) throws MojoExecutionException {
        String compilerVersion = this.project.getProperties().getProperty("maven-compiler-plugin.version", DEFAULT_COMPILER_PLUGIN_VERSION);
        this.project.addCompileSourceRoot(sourcesPath.toString());
        Xpp3Dom compilerConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoots", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoot", (String)sourcesPath.toString())}), MojoExecutor.element((String)"compilePath", (MojoExecutor.Element[])((MojoExecutor.Element[])runtimeClasspathElements.stream().map(classpathElement -> MojoExecutor.element((String)"compilePath", (String)classpathElement)).toArray(MojoExecutor.Element[]::new)))});
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)compilerVersion)), (String)MojoExecutor.goal((String)"compile"), (Xpp3Dom)compilerConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void compileGeneratedTestSources(Path sourcesPath, List<String> testClasspathElements) throws MojoExecutionException {
        String compilerVersion = this.project.getProperties().getProperty("maven-compiler-plugin.version", DEFAULT_COMPILER_PLUGIN_VERSION);
        this.project.addTestCompileSourceRoot(sourcesPath.toString());
        Xpp3Dom compilerConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoots", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoot", (String)sourcesPath.toString())}), MojoExecutor.element((String)"compilePath", (MojoExecutor.Element[])((MojoExecutor.Element[])testClasspathElements.stream().map(classpathElement -> MojoExecutor.element((String)"compilePath", (String)classpathElement)).toArray(MojoExecutor.Element[]::new)))});
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)compilerVersion)), (String)MojoExecutor.goal((String)"testCompile"), (Xpp3Dom)compilerConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void processGeneratedResources(Path sourcePath, Path destinationPath) throws MojoExecutionException {
        String resourcesVersion = this.project.getProperties().getProperty("maven-resources-plugin.version", "3.2.0");
        Xpp3Dom resourceConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)sourcePath.toString())})}), MojoExecutor.element((String)"outputDirectory", (String)destinationPath.toString())});
        Resource resource = new Resource();
        resource.setDirectory(sourcePath.toString());
        this.project.addResource(resource);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)resourcesVersion)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)resourceConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void processGeneratedTestResources(Path sourcePath, Path destinationPath) throws MojoExecutionException {
        String resourcesVersion = this.project.getProperties().getProperty("maven-resources-plugin.version", "3.2.0");
        Xpp3Dom resourceConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)sourcePath.toString())})}), MojoExecutor.element((String)"outputDirectory", (String)destinationPath.toString())});
        Resource resource = new Resource();
        resource.setDirectory(sourcePath.toString());
        this.project.addTestResource(resource);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)resourcesVersion)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)resourceConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }
}

