/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.ai.mcp.client.McpAsyncClient;
import org.springframework.ai.mcp.client.McpSyncClient;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.McpTransport;
import org.springframework.ai.mcp.util.Assert;

public class McpClient {
    private McpClient() {
    }

    public static Builder using(McpTransport transport) {
        return new Builder(transport);
    }

    @Deprecated
    public static McpAsyncClient async(McpTransport transport) {
        return McpClient.using(transport).async();
    }

    @Deprecated
    public static McpAsyncClient async(McpTransport transport, Duration requestTimeout) {
        return McpClient.using(transport).requestTimeout(requestTimeout).async();
    }

    @Deprecated
    public static McpSyncClient sync(McpTransport transport) {
        return McpClient.using(transport).sync();
    }

    @Deprecated
    public static McpSyncClient sync(McpTransport transport, Duration requestTimeout) {
        return McpClient.using(transport).requestTimeout(requestTimeout).sync();
    }

    public static class Builder {
        private final McpTransport transport;
        private Duration requestTimeout = Duration.ofSeconds(20L);
        private boolean rootsListChangedNotification = false;
        private List<Supplier<List<McpSchema.Root>>> rootsListProviders = new ArrayList<Supplier<List<McpSchema.Root>>>();
        private List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Tool>>>();
        private List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers = new ArrayList<Consumer<List<McpSchema.Resource>>>();
        private List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Prompt>>>();

        private Builder(McpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder rootsListChangedNotification(boolean rootsListChangedNotification) {
            this.rootsListChangedNotification = rootsListChangedNotification;
            return this;
        }

        public Builder rootsListProvider(Supplier<List<McpSchema.Root>> rootsListProvider) {
            this.rootsListProviders.add(rootsListProvider);
            return this;
        }

        public Builder toolsChangeConsumer(Consumer<List<McpSchema.Tool>> toolsChangeConsumer) {
            this.toolsChangeConsumers.add(toolsChangeConsumer);
            return this;
        }

        public Builder resourcesChangeConsumer(Consumer<List<McpSchema.Resource>> resourcesChangeConsumer) {
            this.resourcesChangeConsumers.add(resourcesChangeConsumer);
            return this;
        }

        public Builder promptsChangeConsumer(Consumer<List<McpSchema.Prompt>> promptsChangeConsumer) {
            this.promptsChangeConsumers.add(promptsChangeConsumer);
            return this;
        }

        public McpSyncClient sync() {
            return new McpSyncClient(this.async());
        }

        public McpAsyncClient async() {
            return new McpAsyncClient(this.transport, this.requestTimeout, this.rootsListProviders, this.rootsListChangedNotification, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.promptsChangeConsumers);
        }
    }
}

