/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrCustomConversions;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.repository.SolrCrudRepository;
import org.springframework.data.solr.repository.SolrRepository;
import org.springframework.data.solr.repository.support.SolrRepositoryFactoryBean;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SolrRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public String getRepositoryFactoryBeanClassName() {
        return SolrRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "solr";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference(BeanDefinitionName.SOLR_OPERATIONS.getBeanName(), attributes.getString("solrTemplateRef"));
        builder.addPropertyValue("schemaCreationSupport", (Object)attributes.getBoolean("schemaCreationSupport"));
        builder.addPropertyReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
        builder.addPropertyReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName(), "solrConverter");
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        super.registerBeansForRoot(registry, configuration);
        SolrRepositoryConfigExtension.registeCustomConversionsIfNotPresent(registry, configuration);
        SolrRepositoryConfigExtension.registerSolrMappingContextIfNotPresent(registry, configuration);
        SolrRepositoryConfigExtension.registerSolrConverterIfNotPresent(registry, configuration);
        SolrRepositoryConfigExtension.registerSolrTemplateIfNotPresent(registry, configuration);
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> BeanDefinitionBuilder.genericBeanDefinition(SolrExceptionTranslator.class).getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)"solrExceptionTranslator", (Object)configuration.getSource());
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        builder.addPropertyReference(BeanDefinitionName.SOLR_OPERATIONS.getBeanName(), element.getAttribute("solr-template-ref"));
        if (StringUtils.hasText((String)element.getAttribute("schema-creation-support"))) {
            builder.addPropertyValue("schemaCreationSupport", (Object)element.getAttribute("schema-creation-support"));
        }
        builder.addPropertyReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
        builder.addPropertyReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName(), "solrConverter");
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(SolrDocument.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Arrays.asList(SolrRepository.class, SolrCrudRepository.class);
    }

    private static void registeCustomConversionsIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            RootBeanDefinition definition = new RootBeanDefinition(SolrCustomConversions.class);
            definition.getConstructorArgumentValues().addGenericArgumentValue(Collections.emptyList());
            definition.setRole(2);
            return definition;
        }, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.CUSTOM_CONVERSIONS.getBeanName(), (Object)configuration.getSource());
    }

    private static void registerSolrMappingContextIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        RootBeanDefinition definition = new RootBeanDefinition(SimpleSolrMappingContext.class);
        definition.setRole(2);
        definition.setSource(configuration.getSource());
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SimpleSolrMappingContext.class);
            builder.setRole(2);
            return builder.getBeanDefinition();
        }, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), (Object)configuration.getSource());
    }

    private static void registerSolrConverterIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MappingSolrConverter.class);
            builder.addConstructorArgReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName());
            builder.addPropertyReference("customConversions", BeanDefinitionName.CUSTOM_CONVERSIONS.getBeanName());
            builder.setRole(2);
            return builder.getBeanDefinition();
        }, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.SOLR_CONVERTER.getBeanName(), (Object)configuration.getSource());
    }

    private static void registerSolrTemplateIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SolrTemplate.class);
            builder.addConstructorArgValue((Object)SolrRepositoryConfigExtension.createHttpSolrClientFactory());
            builder.addConstructorArgReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName());
            return builder.getBeanDefinition();
        }, (BeanDefinitionRegistry)registry, (String)"solrTemplate", (Object)configuration.getSource());
    }

    private static BeanDefinition createHttpSolrClientFactory() {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpSolrClientFactory.class);
        builder.addConstructorArgReference(BeanDefinitionName.SOLR_CLIENT.getBeanName());
        return builder.getBeanDefinition();
    }

    static enum BeanDefinitionName {
        SOLR_MAPPTING_CONTEXT("solrMappingContext"),
        SOLR_OPERATIONS("solrOperations"),
        SOLR_CLIENT("solrClient"),
        SOLR_CONVERTER("solrConverter"),
        CUSTOM_CONVERSIONS("customConversions");

        String beanName;

        private BeanDefinitionName(String beanName) {
            this.beanName = beanName;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

