/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.AnyCriteria;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.GroupOptions;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.SpellcheckOptions;
import org.springframework.data.solr.core.query.StatsOptions;
import org.springframework.lang.Nullable;

public interface Query
extends SolrDataQuery {
    public static final int DEFAULT_PAGE_SIZE = 10;

    public <T extends Query> T addProjectionOnField(Field var1);

    default public <T extends Query> T projectAllFields() {
        return this.addProjectionOnField(Field.of("*"));
    }

    public <T extends Query> T setPageRequest(Pageable var1);

    public <T extends Query> T setOffset(Long var1);

    public <T extends Query> T setRows(Integer var1);

    public <T extends Query> T addGroupByField(Field var1);

    public <T extends Query> T addFilterQuery(FilterQuery var1);

    public <T extends Query> T setTimeAllowed(Integer var1);

    public List<FilterQuery> getFilterQueries();

    @Deprecated
    public Pageable getPageRequest();

    @Nullable
    public Long getOffset();

    @Nullable
    public Integer getRows();

    public List<Field> getGroupByFields();

    public List<Field> getProjectionOnFields();

    public <T extends Query> T addSort(Sort var1);

    @Nullable
    public Sort getSort();

    @Nullable
    public Integer getTimeAllowed();

    public void setDefaultOperator(Operator var1);

    @Nullable
    public Operator getDefaultOperator();

    @Nullable
    public String getDefType();

    public void setDefType(String var1);

    @Nullable
    public String getRequestHandler();

    public void setRequestHandler(String var1);

    public <T extends Query> T setGroupOptions(GroupOptions var1);

    @Nullable
    public GroupOptions getGroupOptions();

    public <T extends Query> T setStatsOptions(StatsOptions var1);

    @Nullable
    public StatsOptions getStatsOptions();

    public <T extends Query> T setSpellcheckOptions(SpellcheckOptions var1);

    @Nullable
    public SpellcheckOptions getSpellcheckOptions();

    public static Query all() {
        return Query.query(AnyCriteria.any());
    }

    public static Query query(Criteria criteria) {
        return new SimpleQuery(criteria);
    }

    public static Query query(String queryString) {
        return new SimpleQuery(queryString);
    }

    public static enum Operator {
        AND("AND"),
        OR("OR"),
        NONE("");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String asQueryStringRepresentation() {
            return this.operator;
        }

        public String toString() {
            return this.asQueryStringRepresentation();
        }
    }
}

